/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.tables;

import com.google.security.zynamics.zylib.general.comparators.LexicalComparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

@Deprecated
public class CTableSorter
extends AbstractTableModel {
    private static final long serialVersionUID = -6803591209710987100L;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    public static final Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    public static final Comparator<Object> COMPARABLE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    protected TableModel tableModel;
    protected Row[] viewToModel;
    protected int[] modelToView;
    protected JTableHeader tableHeader;
    protected MouseListener mouseListener;
    protected TableModelListener tableModelListener;
    protected Map<Class, Comparator> columnComparators = new HashMap<Class, Comparator>();
    protected HashMap<Integer, Comparator> primaryColumnComparator = new HashMap();
    protected List<Directive> sortingColumns = new ArrayList<Directive>();

    public CTableSorter() {
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
    }

    public CTableSorter(TableModel tableModel) {
        this();
        this.setTableModel(tableModel);
    }

    public CTableSorter(TableModel tableModel, JTableHeader tableHeader) {
        this();
        this.setTableHeader(tableHeader);
        this.setTableModel(tableModel);
    }

    private Directive getDirective(int column) {
        for (int i2 = 0; i2 < this.sortingColumns.size(); ++i2) {
            Directive directive = this.sortingColumns.get(i2);
            if (directive.column != column) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            int tableModelRowCount = this.tableModel.getRowCount();
            this.viewToModel = new Row[tableModelRowCount];
            for (int row = 0; row < tableModelRowCount; ++row) {
                this.viewToModel[row] = new Row(row);
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    protected void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    protected void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    protected Comparator<Object> getComparator(int column) {
        Class<?> columnType = this.tableModel.getColumnClass(column);
        Comparator comparator = this.primaryColumnComparator.get(column);
        if (comparator != null) {
            return comparator;
        }
        comparator = this.columnComparators.get(columnType);
        if (comparator != null) {
            return comparator;
        }
        if (columnType.equals(String.class)) {
            return new LexicalComparator();
        }
        if (Comparable.class.isAssignableFrom(columnType)) {
            return COMPARABLE_COMPARATOR;
        }
        return new LexicalComparator();
    }

    protected Icon getHeaderRendererIcon(int column, int size) {
        Directive directive = this.getDirective(column);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == -1, size, this.sortingColumns.indexOf(directive));
    }

    protected int[] getModelToView() {
        if (this.modelToView == null) {
            int n2 = this.getViewToModel().length;
            this.modelToView = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.modelToView[this.modelIndex((int)i2)] = i2;
            }
        }
        return this.modelToView;
    }

    public Class getColumnClass(int column) {
        return this.tableModel.getColumnClass(column);
    }

    @Override
    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    @Override
    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    public int getSortingStatus(int column) {
        return this.getDirective((int)column).direction;
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.tableModel.getValueAt(this.modelIndex(row), column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.tableModel.isCellEditable(this.modelIndex(row), column);
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    public int modelIndex(int viewIndex) {
        if (viewIndex >= 0) {
            return this.getViewToModel()[viewIndex].modelIndex;
        }
        return 0;
    }

    public void setColumnComparator(Class type, Comparator<Object> comparator) {
        if (comparator == null) {
            this.columnComparators.remove(type);
        } else {
            this.columnComparators.put(type, comparator);
        }
    }

    public void setColumnComparator(int column, Comparator comparator) {
        if (comparator != null) {
            this.primaryColumnComparator.put(column, comparator);
        }
    }

    public void setSortingStatus(int column, int status) {
        Directive directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (status != 0) {
            this.sortingColumns.add(new Directive(column, status));
        }
        this.sortingStatusChanged();
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        this.tableModel.setValueAt(aValue, this.modelIndex(row), column);
    }

    public int viewIndex(int modelIndex) {
        if (modelIndex >= 0) {
            return this.getModelToView()[modelIndex];
        }
        return 0;
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent e2) {
            if (!CTableSorter.this.isSorting()) {
                CTableSorter.this.clearSortingState();
                CTableSorter.this.fireTableChanged(e2);
                return;
            }
            if (e2.getFirstRow() == -1) {
                CTableSorter.this.cancelSorting();
                CTableSorter.this.fireTableChanged(e2);
                return;
            }
            int column = e2.getColumn();
            if (e2.getFirstRow() == e2.getLastRow() && column != -1 && CTableSorter.this.getSortingStatus(column) == 0 && CTableSorter.this.modelToView != null) {
                int viewIndex = CTableSorter.this.getModelToView()[e2.getFirstRow()];
                CTableSorter.this.fireTableChanged(new TableModelEvent(CTableSorter.this, viewIndex, viewIndex, column, e2.getType()));
                return;
            }
            CTableSorter.this.clearSortingState();
            CTableSorter.this.fireTableDataChanged();
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        protected TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c2 = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c2 instanceof JLabel) {
                JLabel l2 = (JLabel)c2;
                l2.setHorizontalTextPosition(2);
                int modelColumn = table.convertColumnIndexToModel(column);
                l2.setIcon(CTableSorter.this.getHeaderRendererIcon(modelColumn, l2.getFont().getSize()));
            }
            return c2;
        }
    }

    private class Row
    implements Comparable<Object> {
        protected int modelIndex;

        public Row(int index) {
            this.modelIndex = index;
        }

        @Override
        public int compareTo(Object o2) {
            int row1 = this.modelIndex;
            int row2 = ((Row)o2).modelIndex;
            Iterator<Directive> iterator = CTableSorter.this.sortingColumns.iterator();
            while (iterator.hasNext()) {
                Directive element;
                Directive directive = element = iterator.next();
                int column = directive.column;
                Object o1 = CTableSorter.this.tableModel.getValueAt(row1, column);
                Object o22 = CTableSorter.this.tableModel.getValueAt(row2, column);
                int comparison = 0;
                comparison = o1 == null && o22 == null ? 0 : (o1 == null ? -1 : (o22 == null ? 1 : CTableSorter.this.getComparator(column).compare(o1, o22)));
                if (comparison == 0) continue;
                return directive.direction == -1 ? -comparison : comparison;
            }
            return 0;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            int viewColumn;
            JTableHeader h2 = (JTableHeader)e2.getSource();
            TableColumnModel columnModel = h2.getColumnModel();
            int column = columnModel.getColumn(viewColumn = columnModel.getColumnIndexAtX(e2.getX())).getModelIndex();
            if (column != -1) {
                int status = CTableSorter.this.getSortingStatus(column);
                if (!e2.isControlDown()) {
                    CTableSorter.this.cancelSorting();
                }
                status += e2.isShiftDown() ? -1 : 1;
                status = (status + 4) % 3 - 1;
                CTableSorter.this.setSortingStatus(column, status);
            }
        }
    }

    private static class Directive {
        protected int column;
        protected int direction;

        public Directive(int column, int direction) {
            this.column = column;
            this.direction = direction;
        }
    }

    private static class Arrow
    implements Icon {
        private final boolean descending;
        private final int size;
        private final int priority;

        public Arrow(boolean descending, int size, int priority) {
            this.descending = descending;
            this.size = size;
            this.priority = priority;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            Color color = c2 == null ? Color.GRAY : c2.getBackground();
            int dx = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int dy = this.descending ? dx : -dx;
            y2 = y2 + 5 * this.size / 6 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g2.translate(x2, y2);
            g2.setColor(color.darker());
            g2.drawLine(dx / 2, dy, 0, 0);
            g2.drawLine(dx / 2, dy + shift, 0, shift);
            g2.setColor(color.brighter());
            g2.drawLine(dx / 2, dy, dx, 0);
            g2.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                g2.setColor(color.darker().darker());
            } else {
                g2.setColor(color.brighter().brighter());
            }
            g2.drawLine(dx, 0, 0, 0);
            g2.setColor(color);
            g2.translate(-x2, -y2);
        }
    }
}

