/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.tables;

import com.google.common.base.Preconditions;
import java.awt.Window;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class CTableSearcher {
    private final JTable m_Table;
    private final Window m_Frame;
    private int m_StartRow = 0;
    private final String m_title;

    public CTableSearcher(Window frame, String windowTitle, JTable table, int startRow) {
        Preconditions.checkNotNull(frame, "Internal Error: Parent window can't be null");
        Preconditions.checkNotNull(windowTitle, "Internal Error: Window title can't be null");
        Preconditions.checkNotNull(table, "Internal Error: Table can't be null");
        this.m_Table = table;
        this.m_Frame = frame;
        this.m_title = windowTitle;
        this.m_StartRow = startRow;
    }

    public void search() {
        String searchText = "";
        do {
            this.m_Frame.repaint();
            searchText = (String)JOptionPane.showInputDialog(this.m_Frame, "Search", this.m_title, 3, null, null, searchText);
            if (searchText == null || searchText.length() <= 0 || this.search(searchText)) continue;
            JOptionPane.showMessageDialog(this.m_Frame, "Search string not found", this.m_title, 0);
        } while (searchText != null && searchText.length() > 0);
    }

    public boolean search(String searchText) {
        int nrOfColumns = this.m_Table.getModel().getColumnCount();
        int nrOfRows = this.m_Table.getRowCount();
        for (int row = 0; row < nrOfRows; ++row) {
            for (int column = 0; column < nrOfColumns; ++column) {
                String text2;
                Object cell = this.m_Table.getModel().getValueAt((row + this.m_StartRow) % nrOfRows, column);
                String string2 = text2 = cell != null ? cell.toString() : "";
                if (!text2.toLowerCase().contains(searchText.toLowerCase())) continue;
                this.m_StartRow = (row + this.m_StartRow) % nrOfRows;
                this.m_Table.setRowSelectionInterval(this.m_StartRow, this.m_StartRow);
                this.m_Table.scrollRectToVisible(this.m_Table.getCellRect(this.m_StartRow, 0, true));
                ++this.m_StartRow;
                return true;
            }
        }
        return false;
    }
}

