/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.scripting.IScriptConsole;
import com.google.security.zynamics.zylib.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptRunner {
    private static final ScriptEngineManager manager = new ScriptEngineManager();

    public static boolean canRun(File file) {
        return manager.getEngineByExtension(FileUtils.getFileExtension(file)) != null;
    }

    public static void runPythonScript(String script, List<Pair<String, Object>> bindings) throws ScriptException {
        ScriptEngine engine = manager.getEngineByName("python");
        ScriptRunner.runScript(engine, script, bindings);
    }

    public static void runScript(File file, List<Pair<String, Object>> bindings) throws ScriptException, IOException {
        ScriptEngine engine = manager.getEngineByExtension(FileUtils.getFileExtension(file));
        Preconditions.checkNotNull(engine, "Error: Script %s has an unknown extension.", file.getAbsolutePath());
        String script = FileUtils.readTextfile(file);
        ScriptRunner.runScript(engine, script, bindings);
    }

    public static void runScript(ScriptEngine engine, File file, List<Pair<String, Object>> bindings) throws ScriptException, IOException {
        Preconditions.checkNotNull(engine, "Error: Script %s has an unknown extension.", file.getAbsolutePath());
        String script = FileUtils.readTextfile(file);
        ScriptRunner.runScript(engine, script, bindings);
    }

    public static Object runScript(ScriptEngine engine, String script, List<Pair<String, Object>> bindings) throws ScriptException {
        for (Pair<String, Object> pair : bindings) {
            engine.put(pair.first(), pair.second());
        }
        return engine.eval(script);
    }

    public static void runScript(String languageName, String script, List<Pair<String, Object>> bindings, IScriptConsole console) throws ScriptException {
        ScriptEngine engine = manager.getEngineByName(languageName);
        Preconditions.checkNotNull(engine, "Error: Unknown scripting language");
        engine.getContext().setWriter(console.getWriter());
        ScriptRunner.runScript(engine, script, bindings);
    }
}

