/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting;

import com.google.security.zynamics.zylib.gui.scripting.ScriptingLanguage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.JComboBox;

public class LanguageBox
extends JComboBox<ScriptingLanguage> {
    public LanguageBox(ScriptEngineManager manager) {
        this.fillLanguageBox(manager);
    }

    private void fillLanguageBox(ScriptEngineManager manager) {
        List<ScriptEngineFactory> factories = manager.getEngineFactories();
        ArrayList<ScriptingLanguage> languages = new ArrayList<ScriptingLanguage>();
        for (ScriptEngineFactory factory : factories) {
            if (!factory.getLanguageName().equals("python")) continue;
            languages.add(new ScriptingLanguage(factory.getLanguageName(), factory.getLanguageVersion()));
        }
        Collections.sort(languages);
        for (ScriptingLanguage language : languages) {
            this.addItem(language);
        }
    }

    public String getSelectedLanguage() {
        return this.getSelectedItem() != null ? ((ScriptingLanguage)this.getSelectedItem()).getName() : null;
    }

    public void setSelectedLanguage(String language) {
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            String element = ((ScriptingLanguage)this.getItemAt(i2)).toString();
            if (!element.equals(language)) continue;
            this.setSelectedIndex(i2);
            return;
        }
    }
}

