/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.scripting;

import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.scripting.IScriptPanel;
import com.google.security.zynamics.zylib.gui.scripting.LanguageBox;
import com.google.security.zynamics.zylib.gui.scripting.console.ConsoleStdoutDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.script.ScriptEngineManager;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public abstract class AbstractScriptPanel
extends JPanel
implements IScriptPanel {
    private static final long serialVersionUID = 8553550256320119608L;
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final JTextPane m_inputPane = new JTextPane();
    private final JTextPane m_OutputPane = new JTextPane();
    private String m_progressWindowTitle;
    private final ConsoleStdoutDocument m_PythonStdoutDocument = new ConsoleStdoutDocument();
    private final ArrayList<Pair<String, Object>> bindings = new ArrayList();
    private final LanguageBox languageBox = new LanguageBox(this.getManager());

    public AbstractScriptPanel(LayoutManager layout) {
        super(layout);
        this.languageBox.addActionListener(new InternalLanguageBoxListener());
        this.m_inputPane.setEditable(true);
        this.m_inputPane.setBackground(new Color(0.97f, 0.97f, 1.0f));
        this.m_inputPane.setFont(new Font(GuiHelper.getMonospaceFont(), 0, 13));
        this.m_OutputPane.setDocument(this.m_PythonStdoutDocument);
        this.m_OutputPane.setEditable(false);
        this.m_OutputPane.setBackground(new Color(0.97f, 0.97f, 1.0f));
        JScrollPane inputScrollPane = new JScrollPane(this.m_inputPane);
        TitledBorder inputAreaBorder = new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), "Command Line");
        inputScrollPane.setBorder(inputAreaBorder);
        inputScrollPane.setPreferredSize(new Dimension(600, 200));
        JScrollPane m_OutputScrollPane = new JScrollPane(this.m_OutputPane);
        TitledBorder outputAreaBorder = new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), "Output");
        m_OutputScrollPane.setBorder(outputAreaBorder);
        m_OutputScrollPane.setPreferredSize(new Dimension(600, 200));
        this.add((Component)this.languageBox, "North");
        this.add(new JSplitPane(0, false, inputScrollPane, m_OutputScrollPane));
    }

    protected ArrayList<Pair<String, Object>> getBindings() {
        return (ArrayList)this.bindings.clone();
    }

    protected JTextPane getInputPane() {
        return this.m_inputPane;
    }

    protected ScriptEngineManager getManager() {
        return this.manager;
    }

    protected ConsoleStdoutDocument getOutputDocument() {
        return this.m_PythonStdoutDocument;
    }

    protected JTextPane getOutputPane() {
        return this.m_OutputPane;
    }

    protected String getProgressWindowTitle() {
        return this.m_progressWindowTitle;
    }

    protected String getSelectedLanguage() {
        return this.languageBox.getSelectedLanguage();
    }

    protected abstract void initConsole();

    protected abstract void updateDocument();

    public void addBinding(String key, Object value) {
        this.bindings.add(new Pair<String, Object>(key, value));
    }

    public void setLanguage(String language) {
        this.languageBox.setSelectedLanguage(language);
    }

    @Override
    public void setOutput(String output) {
        this.m_OutputPane.setText(output);
    }

    public void setProgressWindowTitle(String title) {
        this.m_progressWindowTitle = title;
    }

    private class InternalLanguageBoxListener
    implements ActionListener {
        private InternalLanguageBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AbstractScriptPanel.this.initConsole();
            AbstractScriptPanel.this.updateDocument();
        }
    }
}

