/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.license;

import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessProgressDialog;
import com.google.security.zynamics.zylib.io.StreamUtils;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;

public class UpdateCheckHelper {
    public static String UPDATE_CHECK_BASE_URL = "http://www.zynamics.com/updates";

    private UpdateCheckHelper() {
    }

    public static void checkForUpdatesWithUi(Window parent, String productName, String currentVersion) {
        UpdateCheckHelper.checkForUpdatesWithUi(parent, productName, currentVersion, "stable");
    }

    public static void checkForUpdatesWithUi(Window parent, String productName, String currentVersion, String currentChannel) {
        URL checkUrl;
        try {
            checkUrl = new URL(String.format("%s/%s/%s", UPDATE_CHECK_BASE_URL, productName.toLowerCase(), currentChannel.toLowerCase()));
        }
        catch (MalformedURLException e2) {
            throw new RuntimeException("Malformed URL template", e2);
        }
        final ArrayList lines = new ArrayList();
        CEndlessHelperThread helper = new CEndlessHelperThread(){

            @Override
            protected void runExpensiveCommand() throws Exception {
                long startTime = new Date().getTime();
                lines.addAll(StreamUtils.readLinesFromReader(new InputStreamReader(checkUrl.openStream())));
                long duration = new Date().getTime() - startTime;
                if (duration < 400L) {
                    Thread.sleep(400L - duration);
                }
            }
        };
        CEndlessProgressDialog.show(parent, System.getProperty(CMessageBox.DEFAULT_WINDOW_TITLE_PROPERTY), "Checking for updates...", helper);
        Exception e3 = helper.getException();
        if (e3 instanceof FileNotFoundException) {
            CMessageBox.showWarning(parent, "Could not check for updates. The update site is unavailable.");
            return;
        }
        if (lines.isEmpty()) {
            CMessageBox.showWarning(parent, "Could not check for updates. The update site returned no data.");
            return;
        }
        if (lines.size() < 2 || !((String)lines.get(1)).matches("\\d{4}-\\d\\d-\\d\\d")) {
            CMessageBox.showWarning(parent, "Could not check for updates. Could not parse the response.");
            return;
        }
        String remoteVersion = (String)lines.get(0);
        int result = UpdateCheckHelper.versionCompare(currentVersion, remoteVersion);
        if (result < 0) {
            CMessageBox.showInformation(parent, String.format("A newer version (%s) is available.", remoteVersion));
            return;
        }
        if (result >= 0) {
            CMessageBox.showInformation(parent, String.format("Your version of zynamics %s is up to date.", productName));
            return;
        }
    }

    public static int versionCompare(String current, String remote) {
        String[] curComp = current.trim().split("\\.|-|\\s+");
        String[] remComp = remote.trim().split("\\.|-|\\s+");
        int result = 0;
        for (int i2 = 0; result == 0 && i2 < Math.min(curComp.length, remComp.length); ++i2) {
            try {
                result = Integer.parseInt(curComp[i2]) - Integer.parseInt(remComp[i2]);
                continue;
            }
            catch (NumberFormatException e2) {
                result = curComp[i2].compareToIgnoreCase(remComp[i2]);
            }
        }
        return result < -1 ? -1 : (result > 1 ? 1 : result);
    }
}

