/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.dndtree;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DNDTree
extends JTree {
    private static final long serialVersionUID = -2933192344665054732L;
    Insets autoscrollInsets = new Insets(20, 20, 20, 20);

    public DNDTree() {
        this.setAutoscrolls(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setEditable(false);
    }

    public static DefaultMutableTreeNode makeDeepCopy(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode copy2 = new DefaultMutableTreeNode(node.getUserObject());
        Enumeration<TreeNode> e2 = node.children();
        while (e2.hasMoreElements()) {
            copy2.add(DNDTree.makeDeepCopy((DefaultMutableTreeNode)e2.nextElement()));
        }
        return copy2;
    }

    public void autoscroll(Point cursorLocation) {
        Insets insets = this.getAutoscrollInsets();
        Rectangle outer = this.getVisibleRect();
        Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
        if (!inner.contains(cursorLocation)) {
            Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.scrollRectToVisible(scrollRect);
        }
    }

    public Insets getAutoscrollInsets() {
        return this.autoscrollInsets;
    }
}

