/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.ProgressDialogs;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IProgressDescription;
import com.google.security.zynamics.zylib.types.common.ICancelableCommand;
import com.google.security.zynamics.zylib.types.common.ICommand;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.CountDownLatch;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class CUnlimitedProgressDialog
extends JDialog
implements IProgressDescription {
    private static final long serialVersionUID = 1009536934858788904L;
    private final ICommand m_command;
    private final InternalWindowListener m_windowListener = new InternalWindowListener();
    private final CProgressPanel m_progressPanel;
    private Exception m_exception;
    private final boolean m_isCancelable;

    private CUnlimitedProgressDialog(Window parent, String title, String description, ICommand command2, boolean isCancelable) {
        super(parent, title, Dialog.ModalityType.DOCUMENT_MODAL);
        Preconditions.checkNotNull(command2, "Error: Comand can't be null.");
        this.m_isCancelable = isCancelable;
        this.addWindowListener(this.m_windowListener);
        this.setDefaultCloseOperation(0);
        this.m_command = command2;
        this.m_progressPanel = CUnlimitedProgressDialog.createProgressPanel(description, isCancelable, this.m_windowListener);
        this.m_progressPanel.setBorder(new EmptyBorder(15, 15, 15, 15));
        this.m_progressPanel.start();
        this.setSubDescription("Please wait...");
        this.add(this.m_progressPanel);
        this.setSize(400, this.getPreferredSize().height);
        this.setMinimumSize(new Dimension(400, this.getPreferredSize().height));
        this.setMaximumSize(new Dimension(Math.max(400, this.getPreferredSize().width), this.getPreferredSize().height));
        this.pack();
        this.setSubDescription("Please wait...");
        if (parent != null) {
            GuiHelper.centerChildToParent(parent, this, true);
        } else {
            GuiHelper.centerOnScreen(this);
        }
    }

    public CUnlimitedProgressDialog(Window parent, String title, String description, ICancelableCommand command2) {
        this(parent, title, description, command2, true);
    }

    public CUnlimitedProgressDialog(Window parent, String title, String description, ICommand command2) {
        this(parent, title, description, command2, false);
    }

    private static CProgressPanel createProgressPanel(String description, boolean isCancelable, InternalWindowListener windowListener) {
        if (isCancelable) {
            return new CProgressPanel(description, true, true, windowListener);
        }
        return new CProgressPanel(description, true, true, true, false);
    }

    private void setException(Exception e2) {
        if (this.m_exception == null) {
            this.m_exception = e2;
        }
    }

    public Exception getException() {
        return this.m_exception;
    }

    @Override
    public synchronized void setDescription(String description) {
        this.m_progressPanel.setText(description);
    }

    @Override
    public synchronized void setSubDescription(String subDescription) {
        this.m_progressPanel.setSubText(subDescription);
    }

    @Override
    public void setVisible(boolean value) {
        if (value && !this.isVisible()) {
            this.m_exception = null;
            CountDownLatch countDownLatch = new CountDownLatch(2);
            Thread mainWorkerThread = new Thread(new InternalCommandThread(countDownLatch));
            mainWorkerThread.start();
            super.setVisible(value);
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e2) {
                throw new RuntimeException(e2);
            }
        } else if (!value && this.isVisible()) {
            super.setVisible(false);
        }
    }

    public boolean wasCanceled() {
        return this.m_isCancelable && ((ICancelableCommand)this.m_command).wasCanceled();
    }

    private class InternalWindowListener
    extends WindowAdapter
    implements ActionListener {
        private InternalWindowListener() {
        }

        private void cancel() {
            try {
                if (CUnlimitedProgressDialog.this.m_isCancelable) {
                    CUnlimitedProgressDialog.this.setDescription("Canceling...");
                    ((ICancelableCommand)CUnlimitedProgressDialog.this.m_command).cancel();
                }
            }
            catch (Exception e2) {
                CUnlimitedProgressDialog.this.setException(e2);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            this.cancel();
        }

        @Override
        public void windowClosing(WindowEvent event) {
            this.cancel();
        }
    }

    private class InternalCommandThread
    implements Runnable {
        private final CountDownLatch m_countDownLatch;

        public InternalCommandThread(CountDownLatch countDownLatch) {
            this.m_countDownLatch = countDownLatch;
        }

        @Override
        public void run() {
            try {
                CUnlimitedProgressDialog.this.m_command.execute();
            }
            catch (Exception e2) {
                CUnlimitedProgressDialog.this.setException(e2);
            }
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CUnlimitedProgressDialog.super.dispose();
                        CUnlimitedProgressDialog.super.setVisible(false);
                        InternalCommandThread.this.m_countDownLatch.countDown();
                    }
                });
            }
            catch (Exception e3) {
                CUnlimitedProgressDialog.this.setException(e3);
            }
            finally {
                this.m_countDownLatch.countDown();
            }
        }
    }
}

