/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.ProgressDialogs;

import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IStandardDescriptionUpdater;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IStandardProgressListener;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IStandardProgressModel;

public abstract class CStandardHelperThread
extends Thread
implements IStandardProgressModel,
IStandardDescriptionUpdater {
    private final ListenerProvider<IStandardProgressListener> m_listeners = new ListenerProvider();
    private Exception m_exception;

    private void notifyListeners() {
        for (IStandardProgressListener listener : this.m_listeners) {
            listener.finished();
        }
    }

    protected void finish() {
        this.notifyListeners();
        this.stop();
    }

    protected abstract void runExpensiveCommand() throws Exception;

    @Override
    public final void addProgressListener(IStandardProgressListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public void closeRequested() {
    }

    public Exception getException() {
        return this.m_exception;
    }

    @Override
    public void next() {
        for (IStandardProgressListener listener : this.m_listeners) {
            listener.next();
        }
    }

    @Override
    public final void removeProgressListener(IStandardProgressListener listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public void reset() {
        for (IStandardProgressListener listener : this.m_listeners) {
            listener.reset();
        }
    }

    @Override
    public final void run() {
        try {
            this.runExpensiveCommand();
        }
        catch (Exception exception) {
            this.m_exception = exception;
        }
        finally {
            this.notifyListeners();
        }
    }

    @Override
    public void setDescription(String description) {
        for (IStandardProgressListener listener : this.m_listeners) {
            listener.changedDescription(description);
        }
    }

    @Override
    public void setMaximum(int maximum) {
        for (IStandardProgressListener listener : this.m_listeners) {
            listener.changedMaximum(maximum);
        }
    }
}

