/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.ProgressDialogs;

import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IEndlessDescriptionUpdater;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IEndlessProgressListener;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.IEndlessProgressModel;

public abstract class CEndlessHelperThread
extends Thread
implements IEndlessProgressModel,
IEndlessDescriptionUpdater {
    private final ListenerProvider<IEndlessProgressListener> m_listeners = new ListenerProvider();
    private Exception m_exception;

    private void notifyListeners() {
        for (IEndlessProgressListener listener : this.m_listeners) {
            listener.finished();
        }
    }

    protected void finish() {
        this.notifyListeners();
        this.stop();
    }

    protected abstract void runExpensiveCommand() throws Exception;

    @Override
    public final void addProgressListener(IEndlessProgressListener listener) {
        this.m_listeners.addListener(listener);
    }

    @Override
    public void closeRequested() {
    }

    public Exception getException() {
        return this.m_exception;
    }

    @Override
    public final void removeProgressListener(IEndlessProgressListener listener) {
        this.m_listeners.removeListener(listener);
    }

    @Override
    public final void run() {
        try {
            this.runExpensiveCommand();
        }
        catch (Exception exception) {
            this.m_exception = exception;
        }
        finally {
            this.notifyListeners();
        }
    }

    @Override
    public void setDescription(String description) {
        for (IEndlessProgressListener listener : this.m_listeners) {
            listener.changedDescription(description);
        }
    }

    public void setGeneralDescription(String description) {
        for (IEndlessProgressListener listener : this.m_listeners) {
            listener.changedGeneralDescription(description);
        }
    }
}

