/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JStackView;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.JHexPanel.JHexView;
import com.google.security.zynamics.zylib.gui.JStackView.IStackModel;
import com.google.security.zynamics.zylib.gui.JStackView.IStackModelListener;
import com.google.security.zynamics.zylib.gui.JStackView.JStackPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public final class JStackView
extends JPanel {
    private static final long serialVersionUID = -7850318708757157383L;
    private final JScrollBar m_scrollbar = new JScrollBar(1, 0, 1, 0, 1);
    private final InternalListener m_listener = new InternalListener();
    private final IStackModel m_model;
    private final JStackPanel m_panel;
    private final JScrollBar m_bottomScrollbar = new JScrollBar(0, 0, 1, 0, 1);

    public JStackView(IStackModel model) {
        super(new BorderLayout());
        Preconditions.checkNotNull(model, "Error: Model argument can not be null");
        this.m_model = model;
        this.m_panel = new JStackPanel(model);
        this.add(this.m_panel);
        this.setFocusable(true);
        this.initScrollbar();
        this.setPreferredSize(new Dimension(400, 400));
        this.m_model.addListener(this.m_listener);
        this.addComponentListener(this.m_listener);
        this.addMouseWheelListener(new InternalMouseListener());
    }

    private void initScrollbar() {
        this.m_scrollbar.addAdjustmentListener(this.m_listener);
        this.m_bottomScrollbar.addAdjustmentListener(this.m_listener);
        this.add((Component)this.m_scrollbar, "East");
        this.add((Component)this.m_bottomScrollbar, "South");
    }

    private void setCurrentPosition(long newPosition) {
        int newFirstLine = (int)((newPosition - this.m_model.getStartAddress()) / 4L);
        this.m_scrollbar.setValue(newFirstLine);
        this.m_panel.repaint();
    }

    private void setHorizontalScrollBarMaximum() {
        int totalWidth = this.m_panel.getOffsetViewWidth() + 10 + 80;
        int realWidth = this.getWidth();
        if (realWidth >= totalWidth || this.m_panel.getCharWidth() == 0) {
            this.m_bottomScrollbar.setValue(0);
            this.m_bottomScrollbar.setEnabled(false);
        } else {
            this.m_bottomScrollbar.setMaximum((totalWidth - realWidth) / this.m_panel.getCharWidth() + 1);
            this.m_bottomScrollbar.setEnabled(true);
        }
    }

    private void setScrollBarMaximum() {
        int visibleRows = this.m_panel.getNumberOfVisibleRows();
        int totalRows = this.m_model.getNumberOfEntries();
        int scrollRange = 2 + totalRows - visibleRows;
        if (scrollRange < 0) {
            scrollRange = 0;
            this.m_scrollbar.setValue(0);
            this.m_scrollbar.setEnabled(false);
        } else {
            this.m_scrollbar.setEnabled(true);
        }
        this.m_scrollbar.setMaximum(scrollRange);
    }

    public String getValueAt(Point point) {
        return this.m_panel.getValueAt(point);
    }

    public void gotoOffset(long offset) {
        this.setCurrentPosition(offset);
    }

    public void setDefinitionStatus(JHexView.DefinitionStatus status) {
        this.m_panel.setDefinitionStatus(status);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_panel.repaint();
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e2) {
            if (!JStackView.this.isEnabled()) {
                return;
            }
            int notches = e2.getWheelRotation();
            JStackView.this.m_scrollbar.setValue(JStackView.this.m_scrollbar.getValue() + notches);
        }
    }

    private class InternalListener
    implements AdjustmentListener,
    ComponentListener,
    IStackModelListener {
        private InternalListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            if (event.getSource() == JStackView.this.m_scrollbar) {
                JStackView.this.m_panel.setFirstRow(event.getValue());
            } else {
                JStackView.this.m_panel.setFirstColumn(event.getValue());
            }
            JStackView.this.m_panel.repaint();
        }

        @Override
        public void componentHidden(ComponentEvent event) {
        }

        @Override
        public void componentMoved(ComponentEvent event) {
        }

        @Override
        public void componentResized(ComponentEvent event) {
            JStackView.this.setScrollBarMaximum();
            JStackView.this.setHorizontalScrollBarMaximum();
        }

        @Override
        public void componentShown(ComponentEvent event) {
        }

        @Override
        public void dataChanged() {
            JStackView.this.setScrollBarMaximum();
            JStackView.this.setHorizontalScrollBarMaximum();
            JStackView.this.m_panel.repaint();
        }
    }
}

