/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.JRegisterView;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.gui.JRegisterView.IRegisterModel;
import com.google.security.zynamics.zylib.gui.JRegisterView.IRegistersChangedListener;
import com.google.security.zynamics.zylib.gui.JRegisterView.RegisterInformation;
import com.google.security.zynamics.zylib.gui.JRegisterView.RegisterInformationInternal;
import java.math.BigInteger;
import java.util.HashMap;

public class SimpleRegisterModel
implements IRegisterModel {
    private final HashMap<String, RegisterInformationInternal> registerMap = new HashMap();
    private final RegisterInformationInternal[] registers;

    public SimpleRegisterModel(RegisterInformation[] registers) {
        this.registers = new RegisterInformationInternal[registers.length];
        this.initializeRegisterInformation(registers);
    }

    private void initializeRegisterInformation(RegisterInformation[] passedRegisters) {
        for (int i2 = 0; i2 < passedRegisters.length; ++i2) {
            RegisterInformationInternal internalRegister;
            RegisterInformation register2 = passedRegisters[i2];
            Preconditions.checkNotNull(register2.getRegisterName(), "Error: register.getRegisterName() argument can not be null");
            String string2 = String.valueOf(register2.getRegisterName());
            Preconditions.checkArgument(this.registerMap.containsKey(register2.getRegisterName()), string2.length() != 0 ? "Error: Duplicate register name ".concat(string2) : new String("Error: Duplicate register name "));
            this.registers[i2] = internalRegister = new RegisterInformationInternal(register2.getRegisterName(), register2.getRegisterSize());
            this.registerMap.put(register2.getRegisterName(), internalRegister);
        }
    }

    @Override
    public void addListener(IRegistersChangedListener registerView) {
    }

    @Override
    public int getNumberOfRegisters() {
        return this.registers.length;
    }

    @Override
    public RegisterInformationInternal[] getRegisterInformation() {
        return this.registers;
    }

    @Override
    public RegisterInformationInternal getRegisterInformation(int register2) {
        return this.registers[register2];
    }

    @Override
    public void setValue(String register2, BigInteger value) {
        Preconditions.checkNotNull(register2, "Error: Argument register can't be null");
        Preconditions.checkArgument(this.registerMap.containsKey(register2), "Error: Invalid register name");
        RegisterInformationInternal registerInfo = this.registerMap.get(register2);
        registerInfo.setValue(value);
        registerInfo.setModified(true);
    }
}

