/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class GuiHelper
implements WindowStateListener {
    public static final int DEFAULT_FONTSIZE = 12;
    public static final Font MONOSPACED_FONT = new Font("Monospaced", 0, 12);
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    private static final GuiHelper instance = new GuiHelper();
    private Field metacityWindowManager = null;
    private Field awtWindowManager = null;
    private boolean needsWindowFix = false;

    private GuiHelper() {
        List<String> linuxDesktops = Arrays.asList("gnome", "gnome-shell", "mate", "cinnamon");
        String desktop = System.getenv("DESKTOP_SESSION");
        if (desktop != null && linuxDesktops.contains(desktop.toLowerCase())) {
            try {
                Class<?> xwm = Class.forName("sun.awt.X11.XWM");
                this.awtWindowManager = xwm.getDeclaredField("awt_wmgr");
                this.awtWindowManager.setAccessible(true);
                Field otherWindowManager = xwm.getDeclaredField("OTHER_WM");
                otherWindowManager.setAccessible(true);
                if (this.awtWindowManager.get(null).equals(otherWindowManager.get(null))) {
                    this.metacityWindowManager = xwm.getDeclaredField("METACITY_WM");
                    this.metacityWindowManager.setAccessible(true);
                    this.needsWindowFix = true;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void windowStateChanged(WindowEvent e2) {
        try {
            this.awtWindowManager.set(null, this.metacityWindowManager.get(null));
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    public static final void applyWindowFix(Window window) {
        if (!GuiHelper.instance.needsWindowFix) {
            return;
        }
        window.removeWindowStateListener(instance);
        window.addWindowStateListener(instance);
        instance.windowStateChanged(null);
    }

    public static final void centerChildToParent(Component parent, Component child, boolean bStayOnScreen) {
        int x2 = parent.getX() + parent.getWidth() / 2 - child.getWidth() / 2;
        int y2 = parent.getY() + parent.getHeight() / 2 - child.getHeight() / 2;
        if (bStayOnScreen) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension ss = new Dimension(tk.getScreenSize());
            if ((double)(x2 + child.getWidth()) > ss.getWidth()) {
                x2 = (int)(ss.getWidth() - (double)child.getWidth());
            }
            if ((double)(y2 + child.getHeight()) > ss.getHeight()) {
                y2 = (int)(ss.getHeight() - (double)child.getHeight());
            }
            if (x2 < 0) {
                x2 = 0;
            }
            if (y2 < 0) {
                y2 = 0;
            }
        }
        child.setLocation(x2, y2);
    }

    public static final void centerOnScreen(Window frame) {
        frame.setLocationRelativeTo(null);
    }

    public static Component findComponentAt(Container c2, Point sp) {
        Point cp2 = new Point(sp.x, sp.y);
        SwingUtilities.convertPointFromScreen(cp2, c2);
        if (!c2.contains(cp2.x, cp2.y)) {
            return c2;
        }
        int ncomponents = c2.getComponentCount();
        Component[] component = c2.getComponents();
        for (int i2 = 0; i2 < ncomponents; ++i2) {
            Component comp = component[i2];
            Point loc = comp.getLocation();
            if (!comp.contains(cp2.x - loc.x, cp2.y - loc.y) || !comp.isVisible()) continue;
            if (comp instanceof Container) {
                Container child = (Container)comp;
                Component deeper = GuiHelper.findComponentAt(child, sp);
                if (deeper == null) continue;
                return deeper;
            }
            return comp;
        }
        return c2;
    }

    public static JComponent findComponentByPredicate(JComponent container, ComponentFilter pred) {
        for (Component c2 : container.getComponents()) {
            if (!(c2 instanceof JComponent)) continue;
            if (pred.accept((JComponent)c2)) {
                return (JComponent)c2;
            }
            JComponent result = GuiHelper.findComponentByPredicate((JComponent)c2, pred);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static String getDefaultFont() {
        return DEFAULT_FONT.getName();
    }

    public static String getMonospaceFont() {
        return MONOSPACED_FONT.getName();
    }

    public static interface ComponentFilter {
        public boolean accept(JComponent var1);
    }
}

