/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.CodeDisplay;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.text.AttributedString;

public class FormattedCharacterBuffer {
    private char[] charBuffer = new char[0];
    private Font[] perCharFonts = new Font[0];
    private static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    private Color[] perCharForegroundColor = new Color[0];
    private Color defaultForegroundColor = Color.BLACK;
    private Color[] perCharBackgroundColor = new Color[0];
    private Color defaultBackgroundColor = Color.WHITE;
    private int numberOfLinesInBuffer;
    private int numberOfColumnsInBuffer;

    public FormattedCharacterBuffer(int lines, int columns) {
        this.numberOfLinesInBuffer = lines;
        this.numberOfColumnsInBuffer = columns;
        this.charBuffer = new char[this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer];
        this.perCharFonts = new Font[this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer];
        this.perCharForegroundColor = new Color[this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer];
        this.perCharBackgroundColor = new Color[this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer];
        this.clear();
    }

    public void clear() {
        for (int i2 = 0; i2 < this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer; ++i2) {
            this.charBuffer[i2] = 32;
            this.perCharFonts[i2] = DEFAULT_FONT;
            this.perCharForegroundColor[i2] = this.defaultForegroundColor;
            this.perCharBackgroundColor[i2] = this.defaultBackgroundColor;
        }
    }

    public FormattedCharacterBuffer(String data, Font font, Color foreground, Color background) {
        this(1, data.length());
        for (int i2 = 0; i2 < this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer; ++i2) {
            this.charBuffer[i2] = data.charAt(i2) == '\n' ? 95 : (int)data.charAt(i2);
            this.perCharFonts[i2] = font;
            this.perCharForegroundColor[i2] = foreground;
            this.perCharBackgroundColor[i2] = background;
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumnsInBuffer;
    }

    public int getNumberOfLines() {
        return this.numberOfLinesInBuffer;
    }

    public FormattedCharacterBuffer setBackgroundColor(Color background) {
        for (int index = 0; index < this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer; ++index) {
            this.perCharBackgroundColor[index] = background;
        }
        return this;
    }

    public void setAt(int lineIndex, int columnIndex, char value, Font font, Color foreground, Color background) {
        int writeIndex = lineIndex * this.numberOfColumnsInBuffer + columnIndex;
        this.charBuffer[writeIndex] = value;
        this.perCharFonts[writeIndex] = font;
        this.perCharForegroundColor[writeIndex] = foreground;
        this.perCharBackgroundColor[writeIndex] = background;
    }

    public boolean copyInto(int lineNum, int columnNum, FormattedCharacterBuffer other) {
        if (lineNum + other.getNumberOfLines() > this.numberOfLinesInBuffer || columnNum + other.getNumberOfColumns() > this.numberOfColumnsInBuffer) {
            return false;
        }
        for (int lineIndex = 0; lineIndex < other.getNumberOfLines(); ++lineIndex) {
            for (int columnIndex = 0; columnIndex < other.getNumberOfColumns(); ++columnIndex) {
                int readIndex = lineIndex * other.getNumberOfColumns() + columnIndex;
                char value = other.charBuffer[readIndex];
                Font font = other.perCharFonts[readIndex];
                Color foreground = other.perCharForegroundColor[readIndex];
                Color background = other.perCharBackgroundColor[readIndex];
                this.setAt(lineNum + lineIndex, columnNum + columnIndex, value, font, foreground, background);
            }
        }
        return true;
    }

    public FormattedCharacterBuffer getLine(int lineIndex) {
        FormattedCharacterBuffer result = new FormattedCharacterBuffer(1, this.numberOfColumnsInBuffer);
        for (int column = 0; column < this.getNumberOfColumns(); ++column) {
            int readIndex = lineIndex * this.getNumberOfColumns() + column;
            char value = this.charBuffer[readIndex];
            Font font = this.perCharFonts[readIndex];
            Color foreground = this.perCharForegroundColor[readIndex];
            Color background = this.perCharBackgroundColor[readIndex];
            result.setAt(0, column, value, font, foreground, background);
        }
        return result;
    }

    protected void paintBuffer(Graphics2D context, int x2, int y2, int skipColumns) {
        context.setFont(this.perCharFonts[0]);
        FontMetrics fontMetrics = context.getFontMetrics();
        context.fillRect(0, 0, this.numberOfColumnsInBuffer * fontMetrics.charWidth('a'), this.numberOfLinesInBuffer * fontMetrics.getHeight());
        for (int i2 = 0; i2 < this.numberOfLinesInBuffer; ++i2) {
            AttributedString stringToDraw = this.getAttributedStringForLine(i2, skipColumns);
            context.drawString(stringToDraw.getIterator(), x2, y2 + fontMetrics.getHeight() * (i2 + 1));
        }
    }

    private AttributedString getAttributedStringForLine(int lineIndex, int skip) {
        String newLine = new String(this.charBuffer, this.numberOfColumnsInBuffer * lineIndex + skip, this.numberOfColumnsInBuffer - skip);
        AttributedString attributedString = new AttributedString(newLine);
        int lineStart = lineIndex * this.numberOfColumnsInBuffer + skip;
        for (int index = 0; index < this.numberOfColumnsInBuffer - skip; ++index) {
            attributedString.addAttribute(TextAttribute.FONT, this.perCharFonts[lineStart + index], index, index + 1);
            attributedString.addAttribute(TextAttribute.BACKGROUND, this.perCharBackgroundColor[lineStart + index], index, index + 1);
            attributedString.addAttribute(TextAttribute.FOREGROUND, this.perCharForegroundColor[lineStart + index], index, index + 1);
        }
        return attributedString;
    }

    public String getCharBufferAsString() {
        StringBuilder buffer = new StringBuilder(this.numberOfLinesInBuffer * this.numberOfColumnsInBuffer);
        for (int lineIndex = 0; lineIndex < this.numberOfLinesInBuffer; ++lineIndex) {
            buffer.append(this.charBuffer, this.numberOfColumnsInBuffer * lineIndex, this.numberOfColumnsInBuffer);
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

