/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.CodeDisplay;

import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplayCoordinate;
import com.google.security.zynamics.zylib.gui.CodeDisplay.FormattedCharacterBuffer;
import com.google.security.zynamics.zylib.gui.CodeDisplay.ICodeDisplayModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.util.ArrayList;

public class CodeDisplayModelExample
implements ICodeDisplayModel {
    private ArrayList<ArrayList<ArrayList<String>>> data = new ArrayList();
    private int totalNumberOfLines = 0;
    private Font fontColumnA = new Font("Monospaced", 1, 12);
    private Font fontColumnB = new Font("Monospaced", 0, 12);
    private Font fontColumnC = new Font("Monospaced", 2, 12);

    public CodeDisplayModelExample() {
        for (int rows = 0; rows < 10000; ++rows) {
            ArrayList<String> field1 = new ArrayList<String>();
            ArrayList<String> field2 = new ArrayList<String>();
            ArrayList<String> field3 = new ArrayList<String>();
            field1.add(String.format("* %d *", rows));
            field2.add(String.format("Code for line %d", rows));
            field3.add(String.format("First comment in line %d", rows));
            field3.add(String.format("Second comment in line %d", rows));
            this.totalNumberOfLines += 2;
            ArrayList<ArrayList<String>> fields = new ArrayList<ArrayList<String>>();
            fields.add(field1);
            fields.add(field2);
            fields.add(field3);
            this.data.add(fields);
        }
    }

    @Override
    public int getNumberOfRows() {
        return this.data.size();
    }

    @Override
    public int getTotalNumberOfLines() {
        return this.totalNumberOfLines;
    }

    @Override
    public int getColumnWidthInCharacters(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return 15;
            }
            case 1: {
                return 40;
            }
            case 2: {
                return 40;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int getTotalWidthInCharacters() {
        int sum = 0;
        for (int index = 0; index < this.getNumberOfColumns(); ++index) {
            sum += this.getColumnWidthInCharacters(index);
        }
        return sum;
    }

    @Override
    public int getMaximumLinesForRow(int rowIndex) {
        int max = 0;
        for (int columnIndex = 0; columnIndex < this.getNumberOfColumns(); ++columnIndex) {
            max = Math.max(this.data.get(rowIndex).get(columnIndex).size(), max);
        }
        return max;
    }

    @Override
    public int getNumberOfColumns() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Line:";
            }
            case 1: {
                return "Code:";
            }
            case 2: {
                return "Comment:";
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static String padRight(String s2, int n2) {
        return String.format(new StringBuilder(16).append("%1$-").append(n2).append("s").toString(), s2);
    }

    @Override
    public FormattedCharacterBuffer getLineFormatted(int rowIndex, int columnIndex, int lineIndex) {
        ArrayList<String> field = this.data.get(rowIndex).get(columnIndex);
        String data = lineIndex >= field.size() ? CodeDisplayModelExample.padRight("", this.getColumnWidthInCharacters(columnIndex)) : CodeDisplayModelExample.padRight(field.get(lineIndex), this.getColumnWidthInCharacters(columnIndex));
        data = data.substring(0, Math.min(data.length(), this.getColumnWidthInCharacters(columnIndex)));
        switch (columnIndex) {
            case 0: {
                return new FormattedCharacterBuffer(data, this.fontColumnA, Color.BLACK, Color.LIGHT_GRAY);
            }
            case 1: {
                return new FormattedCharacterBuffer(data, this.fontColumnB, Color.WHITE, Color.DARK_GRAY);
            }
            case 2: {
                return new FormattedCharacterBuffer(data, this.fontColumnC, Color.LIGHT_GRAY, Color.BLACK);
            }
        }
        return null;
    }

    @Override
    public boolean canHaveCaret(CodeDisplayCoordinate coordinate) {
        return coordinate.getColumn() != 0;
    }

    @Override
    public boolean isEditable(CodeDisplayCoordinate coordinate) {
        return coordinate.getColumn() == 2;
    }

    @Override
    public void keyPressedOrTyped(CodeDisplayCoordinate coordinate, KeyEvent event) {
        if (!event.isActionKey()) {
            switch (event.getKeyCode()) {
                case 10: {
                    break;
                }
                default: {
                    String stringToEdit = this.data.get(coordinate.getRow()).get(coordinate.getColumn()).get(coordinate.getLine());
                    if (stringToEdit.length() < coordinate.getFieldIndex()) {
                        stringToEdit = CodeDisplayModelExample.padRight(stringToEdit, coordinate.getFieldIndex());
                    }
                    String string2 = String.valueOf(stringToEdit.substring(0, coordinate.getFieldIndex()));
                    char c2 = event.getKeyChar();
                    String string3 = String.valueOf(stringToEdit.substring(coordinate.getFieldIndex()));
                    String newString = new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(c2).append(string3).toString();
                    this.data.get(coordinate.getRow()).get(coordinate.getColumn()).set(coordinate.getLine(), newString);
                    coordinate.setFieldIndex(coordinate.getFieldIndex() + 1);
                    break;
                }
            }
        } else {
            switch (event.getKeyCode()) {
                case 40: {
                    break;
                }
                case 38: {
                    break;
                }
                case 37: {
                    coordinate.setFieldIndex(coordinate.getFieldIndex() - 1);
                    break;
                }
                case 39: {
                    coordinate.setFieldIndex(coordinate.getFieldIndex() + 1);
                }
            }
        }
    }

    @Override
    public boolean hasHeaderRow() {
        return false;
    }

    @Override
    public FormattedCharacterBuffer getHeader(int columnIndex) {
        return null;
    }
}

