/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui.CodeDisplay;

import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplayCoordinate;
import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplayEventListener;
import com.google.security.zynamics.zylib.gui.CodeDisplay.FormattedCharacterBuffer;
import com.google.security.zynamics.zylib.gui.CodeDisplay.ICodeDisplayModel;
import com.google.security.zynamics.zylib.gui.JCaret.ICaretListener;
import com.google.security.zynamics.zylib.gui.JCaret.JCaret;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class CodeDisplay
extends JComponent {
    private FontMetrics fontMetrics;
    private Font textFont;
    private final JScrollBar verticalScrollbar = new JScrollBar(1, 0, 1, 0, 1);
    private final JScrollBar horizontalScrollbar = new JScrollBar(0, 0, 1, 0, 1);
    private final InternalListener listener = new InternalListener();
    private final ICodeDisplayModel codeModel;
    private BufferedImage bufferedImage;
    private Graphics2D bufferedGraphics;
    private int fontCharWidth = 0;
    private int fontLineHeight = 0;
    private final JCaret caret = new JCaret();
    private CodeDisplayCoordinate caretPosition = new CodeDisplayCoordinate(0, 0, 0, 0);
    private int caretX = 0;
    private int caretY = 0;
    private int currentlyVisibleLines = 0;
    private int currentlyVisibleColumns = 0;
    private int currentFirstRow = 0;
    private int currentFirstLine = 0;
    private int currentFirstCharColumn = 0;
    private FormattedCharacterBuffer charBuffer = new FormattedCharacterBuffer(0, 0);
    private List<CodeDisplayEventListener> eventListeners = new ArrayList<CodeDisplayEventListener>();
    private TreeMap<Integer, CodeDisplayCoordinate> yCoordinateToRowAndLine = new TreeMap();

    public static String padRight(String s2, int n2) {
        if (n2 == 0) {
            return "";
        }
        return String.format(new StringBuilder(16).append("%1$-").append(n2).append("s").toString(), s2);
    }

    public CodeDisplay(ICodeDisplayModel codeDisplayModel) {
        this.codeModel = codeDisplayModel;
        this.textFont = new Font("Monospaced", 0, 12);
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.initializeListeners();
        this.initializeScrollbars();
        this.initializeFontMetrics(this.textFont);
        this.currentlyVisibleLines = this.getNumberOfVisibleLines();
        this.currentlyVisibleColumns = this.getNumberOfVisibleColumns();
        this.initializeGraphicsBuffer();
        this.setScrollBarMaximum();
        this.setEnabled(true);
        int xPosition = 0;
        CodeDisplayCoordinate testCoordinate = new CodeDisplayCoordinate(0, 0, 0, 0);
        for (int columnIndex = 0; columnIndex < this.codeModel.getNumberOfColumns(); ++columnIndex) {
            xPosition += this.codeModel.getColumnWidthInCharacters(columnIndex);
            testCoordinate.setColumn(columnIndex);
            if (!this.codeModel.canHaveCaret(testCoordinate)) continue;
            this.setCaretPosition(testCoordinate);
            this.caretX = xPosition;
            this.caretY = 1;
        }
    }

    private void initializeGraphicsBuffer() {
        this.bufferedImage = new BufferedImage((this.codeModel.getTotalWidthInCharacters() + 1) * this.fontCharWidth, (this.currentlyVisibleLines + 10) * this.fontLineHeight, 1);
        this.bufferedGraphics = (Graphics2D)this.bufferedImage.getGraphics();
    }

    private void notifyCaretListeners() {
        for (CodeDisplayEventListener listener : this.eventListeners) {
            listener.caretChanged(this.caretPosition);
        }
    }

    private void initializeFontMetrics(Font font) {
        BufferedImage temporaryImage = new BufferedImage(10, 10, 1);
        Graphics2D temporaryGraphics2D = (Graphics2D)temporaryImage.getGraphics();
        temporaryGraphics2D.setFont(font);
        this.fontMetrics = temporaryGraphics2D.getFontMetrics();
        this.fontCharWidth = this.fontMetrics.getMaxAdvance();
        this.fontLineHeight = this.fontMetrics.getHeight();
    }

    private void initializeListeners() {
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
        this.addMouseWheelListener(this.listener);
        this.addFocusListener(this.listener);
        this.addComponentListener(this.listener);
        this.addKeyListener(this.listener);
        this.caret.addCaretListener(this.listener);
    }

    private void initializeScrollbars() {
        this.verticalScrollbar.addAdjustmentListener(this.listener);
        this.add((Component)this.verticalScrollbar, "East");
        this.horizontalScrollbar.addAdjustmentListener(this.listener);
        this.add((Component)this.horizontalScrollbar, "South");
    }

    private int getNumberOfVisibleColumns() {
        int rawWidth = this.getWidth() - this.verticalScrollbar.getWidth();
        return rawWidth / this.fontCharWidth + (rawWidth % this.fontCharWidth == 0 ? 0 : 1);
    }

    private int getNumberOfVisibleLines() {
        int rawHeight = this.getHeight() - this.horizontalScrollbar.getHeight();
        return rawHeight / this.fontLineHeight + (rawHeight % this.fontLineHeight == 0 ? 0 : 1);
    }

    private void setScrollBarMaximum() {
        int totalRows = this.codeModel.getNumberOfRows();
        int scrollRange = totalRows;
        if (scrollRange < 0) {
            scrollRange = 0;
            this.verticalScrollbar.setValue(0);
            this.verticalScrollbar.setEnabled(false);
        } else {
            this.verticalScrollbar.setEnabled(true);
        }
        this.verticalScrollbar.setMaximum(scrollRange);
        int totalWidth = this.codeModel.getTotalWidthInCharacters();
        int realWidth = this.getWidth();
        if ((realWidth -= this.verticalScrollbar.getWidth()) >= totalWidth * this.fontCharWidth) {
            this.horizontalScrollbar.setValue(0);
            this.horizontalScrollbar.setEnabled(false);
        } else {
            this.horizontalScrollbar.setMaximum(totalWidth + 1);
            this.horizontalScrollbar.setEnabled(true);
        }
    }

    private void updateCharacterBufferFromModel() {
        this.charBuffer.clear();
        this.charBuffer.setBackgroundColor(Color.LIGHT_GRAY.brighter());
        this.currentFirstRow = this.verticalScrollbar.getValue();
        this.currentFirstCharColumn = this.horizontalScrollbar.getValue();
        int totalCopiedLines = 0;
        if (this.codeModel.hasHeaderRow()) {
            totalCopiedLines = 1;
            int currentColumnIndex = 0;
            for (int fieldIndex = 0; fieldIndex < this.codeModel.getNumberOfColumns(); ++fieldIndex) {
                this.charBuffer.copyInto(0, currentColumnIndex, this.codeModel.getHeader(fieldIndex));
                currentColumnIndex += this.codeModel.getColumnWidthInCharacters(fieldIndex);
            }
        }
        for (int rowIndex = this.currentFirstRow; rowIndex < Math.min(this.currentFirstRow + this.currentlyVisibleLines, this.codeModel.getNumberOfRows()); ++rowIndex) {
            int lineIndex;
            int n2 = lineIndex = rowIndex == this.currentFirstRow ? this.currentFirstLine : 0;
            while (lineIndex < this.codeModel.getMaximumLinesForRow(rowIndex)) {
                int currentColumnIndex = 0;
                for (int fieldIndex = 0; fieldIndex < this.codeModel.getNumberOfColumns(); ++fieldIndex) {
                    int linestart;
                    FormattedCharacterBuffer line;
                    if (this.caretPosition.getRow() == rowIndex && this.caretPosition.getLine() == lineIndex && this.caretPosition.getColumn() == fieldIndex) {
                        this.caretX = currentColumnIndex + this.caretPosition.getFieldIndex();
                        this.caretY = totalCopiedLines;
                    }
                    if ((line = this.codeModel.getLineFormatted(rowIndex, fieldIndex, lineIndex)) != null) {
                        this.charBuffer.copyInto(totalCopiedLines, currentColumnIndex, line);
                    }
                    if (!this.yCoordinateToRowAndLine.containsKey(linestart = totalCopiedLines * this.fontLineHeight + this.fontLineHeight / 2)) {
                        this.yCoordinateToRowAndLine.put(linestart, new CodeDisplayCoordinate(rowIndex, lineIndex, 0, 0));
                    } else {
                        CodeDisplayCoordinate coordinate = this.yCoordinateToRowAndLine.get(linestart);
                        coordinate.setRow(rowIndex);
                        coordinate.setLine(lineIndex);
                    }
                    currentColumnIndex += this.codeModel.getColumnWidthInCharacters(fieldIndex);
                }
                ++totalCopiedLines;
                ++lineIndex;
            }
        }
        this.setScrollBarMaximum();
    }

    @Override
    protected void paintComponent(Graphics gx) {
        super.paintComponent(gx);
        this.bufferedGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.updateVisibleLinesAndColumns();
        this.updateCharacterBufferFromModel();
        this.currentFirstRow = this.verticalScrollbar.getValue();
        this.currentFirstCharColumn = this.horizontalScrollbar.getValue();
        this.charBuffer.paintBuffer(this.bufferedGraphics, 0, 0, this.currentFirstCharColumn);
        gx.drawImage(this.bufferedImage, 2, 2, this);
        this.caret.draw(gx, 2 + this.caretX * this.fontCharWidth, 6 + this.caretY * this.fontLineHeight, this.fontLineHeight - 1);
    }

    void updateVisibleLinesAndColumns() {
        int currentVisibleLines = this.getNumberOfVisibleLines();
        int currentVisibleColumns = this.getNumberOfVisibleColumns();
        if (this.currentlyVisibleLines != currentVisibleLines || this.currentlyVisibleColumns != currentVisibleColumns) {
            this.currentlyVisibleLines = currentVisibleLines;
            this.currentlyVisibleColumns = currentVisibleColumns;
            int properWidth = this.codeModel.getTotalWidthInCharacters();
            int properLines = this.currentlyVisibleLines + 1;
            this.charBuffer = new FormattedCharacterBuffer(properLines, properWidth);
            this.bufferedImage = new BufferedImage(properWidth * this.fontCharWidth, properLines * this.fontLineHeight, 1);
            this.bufferedGraphics = (Graphics2D)this.bufferedImage.getGraphics();
        }
    }

    void setSelectionStart() {
    }

    private boolean fillColumnAndFieldIndexFromX(int x2, CodeDisplayCoordinate coordinate) {
        x2 += this.currentFirstCharColumn * this.fontCharWidth;
        int columnstart = 0;
        int characterIndex = 0;
        for (int index = 0; index < this.codeModel.getNumberOfColumns(); ++index) {
            int columnend = columnstart + this.codeModel.getColumnWidthInCharacters(index) * this.fontCharWidth;
            if (x2 >= columnstart && x2 < columnend) {
                characterIndex = (x2 -= columnstart) / this.fontCharWidth;
                coordinate.setColumn(index);
                coordinate.setFieldIndex(characterIndex);
                return true;
            }
            columnstart = columnend;
        }
        return false;
    }

    private boolean fillCoordinateFromXY(int x2, int y2, CodeDisplayCoordinate newCoordinate) {
        Map.Entry<Integer, CodeDisplayCoordinate> coordinate = this.yCoordinateToRowAndLine.floorEntry(y2);
        if (coordinate == null) {
            newCoordinate.setRow(2);
            newCoordinate.setColumn(1);
            return true;
        }
        newCoordinate.setRow(coordinate.getValue().getRow());
        newCoordinate.setLine(coordinate.getValue().getLine());
        return this.fillColumnAndFieldIndexFromX(x2, newCoordinate);
    }

    public CodeDisplayCoordinate getCaretPosition() {
        return this.caretPosition;
    }

    public void setCaretPosition(CodeDisplayCoordinate coordinate) {
        this.caretPosition = coordinate;
    }

    public int rowAtPoint(Point point) {
        CodeDisplayCoordinate coordinate = new CodeDisplayCoordinate(0, 0, 0, 0);
        this.fillCoordinateFromXY(point.x, point.y, coordinate);
        return coordinate.getRow();
    }

    public int columnAtPoint(Point point) {
        CodeDisplayCoordinate coordinate = new CodeDisplayCoordinate(0, 0, 0, 0);
        this.fillCoordinateFromXY(point.x, point.y, coordinate);
        return coordinate.getColumn();
    }

    public int lineAtPoint(Point point) {
        CodeDisplayCoordinate coordinate = new CodeDisplayCoordinate(0, 0, 0, 0);
        this.fillCoordinateFromXY(point.x, point.y, coordinate);
        return coordinate.getLine();
    }

    public void addCaretChangedListener(CodeDisplayEventListener e2) {
        this.eventListeners.add(e2);
    }

    public void removeCaretChangedListener(CodeDisplayEventListener e2) {
        this.eventListeners.remove(e2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.fontCharWidth * this.codeModel.getTotalWidthInCharacters(), this.fontLineHeight * 40);
    }

    private class InternalListener
    extends MouseAdapter
    implements AdjustmentListener,
    FocusListener,
    ICaretListener,
    ComponentListener,
    KeyListener {
        private InternalListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            CodeDisplay.this.repaint();
        }

        @Override
        public void caretStatusChanged(JCaret source) {
            CodeDisplay.this.repaint();
        }

        @Override
        public void componentHidden(ComponentEvent event) {
        }

        @Override
        public void componentMoved(ComponentEvent event) {
        }

        @Override
        public void componentResized(ComponentEvent event) {
            CodeDisplay.this.updateVisibleLinesAndColumns();
            CodeDisplay.this.updateCharacterBufferFromModel();
            CodeDisplay.this.setScrollBarMaximum();
        }

        @Override
        public void componentShown(ComponentEvent event) {
        }

        @Override
        public void focusGained(FocusEvent event) {
            CodeDisplay.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent event) {
            CodeDisplay.this.repaint();
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (!event.isActionKey()) {
                return;
            }
            CodeDisplayCoordinate newCoordinate = new CodeDisplayCoordinate(CodeDisplay.this.caretPosition);
            int line = newCoordinate.getLine();
            int row = newCoordinate.getRow();
            int fieldIndex = newCoordinate.getFieldIndex();
            int column = newCoordinate.getColumn();
            switch (event.getKeyCode()) {
                case 38: {
                    if (line == 0) {
                        int newRow = row - 1;
                        newCoordinate.setRow(Math.max(newRow, 0));
                        int maximumLines = CodeDisplay.this.codeModel.getMaximumLinesForRow(newRow);
                        if (maximumLines <= 0) break;
                        newCoordinate.setLine(CodeDisplay.this.codeModel.getMaximumLinesForRow(newRow) - 1);
                        break;
                    }
                    newCoordinate.setLine(line - 1);
                    break;
                }
                case 40: {
                    if (line == CodeDisplay.this.codeModel.getMaximumLinesForRow(row) - 1) {
                        newCoordinate.setRow(Math.min(row + 1, CodeDisplay.this.codeModel.getNumberOfRows()));
                        newCoordinate.setLine(0);
                        break;
                    }
                    newCoordinate.setLine(line + 1);
                    break;
                }
                case 37: {
                    if (fieldIndex == 0) {
                        newCoordinate.setColumn(column - 1);
                        newCoordinate.setFieldIndex(CodeDisplay.this.codeModel.getColumnWidthInCharacters(column - 1) - 1);
                        break;
                    }
                    newCoordinate.setFieldIndex(fieldIndex - 1);
                    break;
                }
                case 39: {
                    fieldIndex = newCoordinate.getFieldIndex();
                    if (fieldIndex == CodeDisplay.this.codeModel.getColumnWidthInCharacters(column) - 1) {
                        newCoordinate.setColumn(column + 1);
                        newCoordinate.setFieldIndex(0);
                        break;
                    }
                    newCoordinate.setFieldIndex(fieldIndex + 1);
                    break;
                }
                case 34: {
                    for (int count = 0; count < CodeDisplay.this.currentlyVisibleLines - 2; ++count) {
                        if (newCoordinate.getLine() >= CodeDisplay.this.codeModel.getMaximumLinesForRow(row) - 1) {
                            newCoordinate.setRow(Math.min(newCoordinate.getRow() + 1, CodeDisplay.this.codeModel.getNumberOfRows()));
                            newCoordinate.setLine(0);
                            continue;
                        }
                        newCoordinate.setLine(newCoordinate.getLine() + 1);
                    }
                    CodeDisplay.this.verticalScrollbar.setValue(newCoordinate.getRow());
                    break;
                }
                case 33: {
                    for (int count = 0; count < CodeDisplay.this.currentlyVisibleLines - 2; ++count) {
                        if (newCoordinate.getLine() == 0) {
                            int newRow = Math.max(newCoordinate.getRow() - 1, 0);
                            newCoordinate.setRow(Math.max(newRow, 0));
                            newCoordinate.setLine(CodeDisplay.this.codeModel.getMaximumLinesForRow(newRow) - 1);
                            continue;
                        }
                        newCoordinate.setLine(Math.max(newCoordinate.getLine() - 1, 0));
                    }
                    CodeDisplay.this.verticalScrollbar.setValue(newCoordinate.getRow());
                    break;
                }
                case 36: {
                    CodeDisplay.this.codeModel.keyPressedOrTyped(newCoordinate, event);
                    break;
                }
                case 35: {
                    CodeDisplay.this.codeModel.keyPressedOrTyped(newCoordinate, event);
                    break;
                }
                case 8: {
                    CodeDisplay.this.codeModel.keyPressedOrTyped(newCoordinate, event);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (CodeDisplay.this.codeModel.canHaveCaret(newCoordinate)) {
                CodeDisplay.this.setCaretPosition(newCoordinate);
                CodeDisplay.this.updateCharacterBufferFromModel();
                CodeDisplay.this.notifyCaretListeners();
                CodeDisplay.this.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (CodeDisplay.this.codeModel.isEditable(CodeDisplay.this.caretPosition)) {
                CodeDisplayCoordinate before = new CodeDisplayCoordinate(CodeDisplay.this.caretPosition);
                CodeDisplay.this.codeModel.keyPressedOrTyped(CodeDisplay.this.caretPosition, event);
                if (!before.equals(CodeDisplay.this.caretPosition)) {
                    CodeDisplay.this.notifyCaretListeners();
                }
                CodeDisplay.this.updateCharacterBufferFromModel();
                CodeDisplay.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            CodeDisplay.this.requestFocusInWindow();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            CodeDisplayCoordinate coordinate = new CodeDisplayCoordinate(0, 0, 0, 0);
            if (!CodeDisplay.this.fillCoordinateFromXY(event.getX(), event.getY(), coordinate)) {
                return;
            }
            if (CodeDisplay.this.codeModel.canHaveCaret(coordinate)) {
                CodeDisplay.this.setCaretPosition(coordinate);
                CodeDisplay.this.updateCharacterBufferFromModel();
                CodeDisplay.this.notifyCaretListeners();
                CodeDisplay.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e2) {
            int notches = e2.getWheelRotation();
            CodeDisplay.this.verticalScrollbar.setValue(CodeDisplay.this.verticalScrollbar.getValue() + notches);
        }
    }
}

