/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import com.google.common.base.Preconditions;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class CHexFormatter
extends JFormattedTextField.AbstractFormatter {
    private static final long serialVersionUID = 6996845563062947862L;
    private final HexFilter filter = new HexFilter();
    private int maxSize = Integer.MAX_VALUE;

    public CHexFormatter() {
    }

    public CHexFormatter(int maxSize) {
        Preconditions.checkArgument(maxSize > 0, "Error: Maximum input size must be positive");
        this.maxSize = maxSize;
    }

    private boolean isValid(String string2, int replaced) {
        if (this.getFormattedTextField().getText().length() - replaced + string2.length() > this.maxSize) {
            this.invalidEdit();
            return false;
        }
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char ch2 = string2.charAt(i2);
            if (Character.digit(ch2, 16) != -1) continue;
            this.invalidEdit();
            return false;
        }
        return true;
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return this.filter;
    }

    @Override
    public Object stringToValue(String s2) {
        return s2;
    }

    @Override
    public String valueToString(Object o2) {
        return (String)o2;
    }

    private class HexFilter
    extends DocumentFilter {
        private HexFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string2, AttributeSet attr) throws BadLocationException {
            if (CHexFormatter.this.isValid(string2, 0)) {
                super.insertString(fb, offset, string2, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string2, AttributeSet attr) throws BadLocationException {
            if (CHexFormatter.this.isValid(string2, length)) {
                super.replace(fb, offset, length, string2, attr);
            }
        }
    }
}

