/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.gui;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class CFilenameFormatter
extends JFormattedTextField.AbstractFormatter {
    private static final int MAX_CHAR = 255;
    private final FilenameFilter filter = new FilenameFilter();
    private final File m_directory;

    public CFilenameFormatter(File directory) {
        Preconditions.checkArgument(directory.exists(), "Error: Direcctory must exist.");
        this.m_directory = directory;
    }

    private boolean isValid(String string2, int selected) {
        if (this.getFormattedTextField().getText().length() - selected + string2.length() > 255 || string2.indexOf("\\") > -1 || string2.indexOf("/") > -1) {
            this.invalidEdit();
            return false;
        }
        String string3 = String.valueOf(this.m_directory.getPath());
        String string4 = String.valueOf(File.separator);
        File file = new File(new StringBuilder(0 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string3).append(string4).append(string2).toString());
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    this.invalidEdit();
                    return false;
                }
                file.delete();
            }
            catch (IOException e2) {
                this.invalidEdit();
                return false;
            }
        }
        return true;
    }

    @Override
    protected DocumentFilter getDocumentFilter() {
        return this.filter;
    }

    @Override
    public Object stringToValue(String s2) {
        return s2;
    }

    @Override
    public String valueToString(Object o2) {
        if (o2 == null) {
            return null;
        }
        return o2.toString();
    }

    private class FilenameFilter
    extends DocumentFilter {
        private FilenameFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string2, AttributeSet attr) throws BadLocationException {
            if (CFilenameFormatter.this.isValid(string2, 0)) {
                super.insertString(fb, offset, string2, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string2, AttributeSet attr) throws BadLocationException {
            if (CFilenameFormatter.this.isValid(string2, length)) {
                super.replace(fb, offset, length, string2, attr);
            }
        }
    }
}

