/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.general.undo;

import com.google.security.zynamics.zylib.general.undo.IUndoable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UndoStack
implements Iterable<IUndoable> {
    private final List<IUndoable> undoStack = new ArrayList<IUndoable>();
    private int undoPosition = 0;

    public void add(IUndoable operation) {
        int toRemove = this.undoStack.size() - this.undoPosition;
        for (int i2 = 0; i2 < toRemove; ++i2) {
            this.undoStack.remove(this.undoPosition);
        }
        this.undoStack.add(operation);
        ++this.undoPosition;
    }

    public boolean canRedo() {
        return this.undoPosition < this.undoStack.size();
    }

    public boolean canUndo() {
        return this.undoPosition > 0;
    }

    @Override
    public Iterator<IUndoable> iterator() {
        return this.undoStack.iterator();
    }

    public void redo() {
        IUndoable operationToUndo = this.undoStack.get(this.undoPosition);
        operationToUndo.revertToSnapshot();
        ++this.undoPosition;
    }

    public void undo() {
        IUndoable operationToUndo = this.undoStack.get(this.undoPosition - 1);
        operationToUndo.undo();
        --this.undoPosition;
    }
}

