/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.general;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class ListenerProvider<T>
implements Iterable<T> {
    private volatile Collection<WeakReference<T>> m_listeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(T listener) {
        Iterable<Object> iterable;
        Preconditions.checkNotNull(listener, "Internal Error: Listener cannot be null");
        if (this.m_listeners == null) {
            iterable = this;
            synchronized (iterable) {
                if (this.m_listeners == null) {
                    this.m_listeners = new LinkedHashSet<WeakReference<T>>();
                }
            }
        }
        iterable = this.m_listeners;
        synchronized (iterable) {
            if (!this.m_listeners.add(new ComparableReference(listener))) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        ArrayList<WeakReference<T>> listenersCopy;
        if (this.m_listeners == null) {
            return Collections.emptyIterator();
        }
        Collection<WeakReference<T>> collection = this.m_listeners;
        synchronized (collection) {
            listenersCopy = new ArrayList<WeakReference<T>>(this.m_listeners);
        }
        ArrayList listeners = new ArrayList();
        for (WeakReference<T> weakT : listenersCopy) {
            Object element = weakT.get();
            if (element == null) continue;
            listeners.add(element);
        }
        return listeners.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(T listener) {
        Preconditions.checkNotNull(listener, "Internal Error: Listener cannot be null");
        if (this.m_listeners != null) {
            Collection<WeakReference<T>> collection = this.m_listeners;
            synchronized (collection) {
                if (!this.m_listeners.remove(new ComparableReference(listener))) {
                    // empty if block
                }
            }
        }
    }

    public class ComparableReference
    extends WeakReference<T> {
        public ComparableReference(T referent) {
            super(referent);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            ComparableReference rhso = (ComparableReference)rhs;
            Object lhsElement = this.get();
            Object rhsElement = rhso.get();
            if (lhsElement == null && rhsElement == null) {
                return true;
            }
            if (lhsElement == null || rhsElement == null) {
                return false;
            }
            return lhsElement.equals(rhsElement);
        }

        public int hashCode() {
            Object element = this.get();
            return element == null ? 0 : element.hashCode();
        }
    }
}

