/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.general;

import java.util.List;

public final class ByteHelpers {
    public static byte[] combine(List<byte[]> dataChunks) {
        int totalSize = 0;
        for (byte[] dataPart : dataChunks) {
            totalSize += dataPart.length;
        }
        byte[] data = new byte[totalSize];
        int index = 0;
        for (byte[] dataPart : dataChunks) {
            System.arraycopy(dataPart, 0, data, index, dataPart.length);
            index += dataPart.length;
        }
        return data;
    }

    public static long readDwordBigEndian(byte[] data, int offset) {
        return ((long)data[offset + 0] & 0xFFL) * 256L * 256L * 256L + ((long)data[offset + 1] & 0xFFL) * 256L * 256L + ((long)data[offset + 2] & 0xFFL) * 256L + ((long)data[offset + 3] & 0xFFL);
    }

    public static long readDwordLittleEndian(byte[] data, int offset) {
        return ((long)data[offset + 3] & 0xFFL) * 256L * 256L * 256L + ((long)data[offset + 2] & 0xFFL) * 256L * 256L + ((long)data[offset + 1] & 0xFFL) * 256L + ((long)data[offset + 0] & 0xFFL);
    }

    public static long readQwordBigEndian(byte[] data, int offset) {
        return ((long)data[offset + 0] & 0xFFL) * 256L * 256L * 256L * 256L * 256L * 256L * 256L + ((long)data[offset + 1] & 0xFFL) * 256L * 256L * 256L * 256L * 256L * 256L + ((long)data[offset + 2] & 0xFFL) * 256L * 256L * 256L * 256L * 256L + ((long)data[offset + 3] & 0xFFL) * 256L * 256L * 256L * 256L + ((long)data[offset + 4] & 0xFFL) * 256L * 256L * 256L + ((long)data[offset + 5] & 0xFFL) * 256L * 256L + ((long)data[offset + 6] & 0xFFL) * 256L + ((long)data[offset + 7] & 0xFFL);
    }

    public static long readQwordLittleEndian(byte[] data, int offset) {
        return ((long)data[offset + 7] & 0xFFL) * 256L * 256L * 256L * 256L * 256L * 256L * 256L + ((long)data[offset + 6] & 0xFFL) * 256L * 256L * 256L * 256L * 256L * 256L + ((long)data[offset + 5] & 0xFFL) * 256L * 256L * 256L * 256L * 256L + ((long)data[offset + 4] & 0xFFL) * 256L * 256L * 256L * 256L + ((long)data[offset + 3] & 0xFFL) * 256L * 256L * 256L + ((long)data[offset + 2] & 0xFFL) * 256L * 256L + ((long)data[offset + 1] & 0xFFL) * 256L + ((long)data[offset + 0] & 0xFFL);
    }

    public static long readWordBigEndian(byte[] data, int offset) {
        return ((long)data[offset + 0] & 0xFFL) * 256L + ((long)data[offset + 1] & 0xFFL);
    }

    public static long readWordLittleEndian(byte[] data, int offset) {
        return ((long)data[offset + 1] & 0xFFL) * 256L + ((long)data[offset + 0] & 0xFFL);
    }

    public static byte[] toArray(List<Byte> list) {
        byte[] output = new byte[list.size()];
        for (int i2 = 0; i2 < output.length; ++i2) {
            output[i2] = list.get(i2);
        }
        return output;
    }

    public static byte[] toBigEndianDword(long value) {
        return new byte[]{(byte)((value & 0xFF000000L) >>> 24), (byte)((value & 0xFF0000L) >>> 16), (byte)((value & 0xFF00L) >>> 8), (byte)(value & 0xFFL)};
    }

    public static byte[] toBigEndianWord(long value) {
        return new byte[]{(byte)((value & 0xFF00L) >>> 8), (byte)(value & 0xFFL)};
    }

    public static byte[] toLittleEndianDword(long value) {
        return new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >>> 8), (byte)((value & 0xFF0000L) >>> 16), (byte)((value & 0xFF000000L) >>> 24)};
    }

    public static byte[] toLittleEndianWord(long value) {
        return new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >>> 8)};
    }
}

