/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.Stack;

public class OperandOrderIterator {
    private final Stack<Pair<IOperandTreeNode, Integer>> m_traversalStack = new Stack();
    private final IOperandTreeNode m_root;
    private boolean m_started = false;

    public OperandOrderIterator(IOperandTreeNode root) {
        this.m_root = Preconditions.checkNotNull(root);
    }

    private void pushLongestPathFrom(IOperandTreeNode node) {
        IOperandTreeNode current = node;
        while (true) {
            this.m_traversalStack.push(new Pair<IOperandTreeNode, Integer>(current, 0));
            if (current.getChildren().size() <= 1 || current.getType() == ExpressionType.EXPRESSION_LIST) break;
            current = current.getChildren().get(0);
        }
    }

    public IOperandTreeNode current() {
        return (IOperandTreeNode)((Pair)this.m_traversalStack.lastElement()).first();
    }

    public boolean next() {
        if (!this.m_started) {
            this.pushLongestPathFrom(this.m_root);
            this.m_started = true;
        } else {
            if (this.m_traversalStack.empty()) {
                throw new RuntimeException("Internal Error: Traversal already finished");
            }
            Pair<IOperandTreeNode, Integer> lastProcessed = this.m_traversalStack.pop();
            IOperandTreeNode lastProcessedNode = lastProcessed.first();
            int lastProcessedChildrenProcessed = lastProcessed.second();
            if (lastProcessedChildrenProcessed < lastProcessedNode.getChildren().size()) {
                if (lastProcessed.first().getChildren().size() > 1) {
                    this.m_traversalStack.add(lastProcessed);
                }
                this.pushLongestPathFrom(lastProcessedNode.getChildren().get(lastProcessedChildrenProcessed));
                return true;
            }
            if (this.m_traversalStack.empty()) {
                return false;
            }
            do {
                Pair<IOperandTreeNode, Integer> parent;
                if ((parent = this.m_traversalStack.pop()).second() >= parent.first().getChildren().size() - 1) continue;
                this.m_traversalStack.push(new Pair<IOperandTreeNode, Integer>(parent.first(), parent.second() + 1));
                return true;
            } while (!this.m_traversalStack.empty());
        }
        return !this.m_traversalStack.empty();
    }
}

