/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.date;

import com.google.common.base.Preconditions;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class DateHelpers {
    public static String formatDate(Date date) {
        Preconditions.checkNotNull(date, "Error: Date argument can't be null.");
        return DateFormat.getDateInstance().format(date);
    }

    public static String formatDate(Date date, int type, Locale locale2) {
        Preconditions.checkNotNull(date, "Error: Date argument can't be null.");
        Preconditions.checkNotNull(locale2, "Error: Locale argument can't be null.");
        String s2 = String.format("%s %s", DateFormat.getDateInstance(type, locale2).format(date), DateFormat.getTimeInstance(type, locale2).format(date));
        return s2;
    }

    public static String formatDateTime(Date date) {
        Preconditions.checkNotNull(date, "Error: Date argument can't be null.");
        return DateFormat.getDateTimeInstance().format(date);
    }

    public static String formatTime(Date date) {
        Preconditions.checkNotNull(date, "Error: Date argument can't be null.");
        return DateFormat.getTimeInstance().format(date);
    }

    public static Date getCurrentDate() {
        return Calendar.getInstance().getTime();
    }

    public static String getCurrentDateString() {
        return DateHelpers.formatDateTime(Calendar.getInstance().getTime());
    }

    public static Date getDate(String dateString, String format) {
        Preconditions.checkArgument(dateString.length() == format.length(), "Date string format exception. Format string must have the same length as the date string.");
        String day = "";
        String month = "";
        String year = "";
        for (int i2 = 0; i2 < format.length(); ++i2) {
            char c2;
            String string2;
            char chr = format.charAt(i2);
            if (chr == 'D') {
                string2 = String.valueOf(day);
                c2 = dateString.charAt(i2);
                day = new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append(c2).toString();
                continue;
            }
            if (chr == 'M') {
                string2 = String.valueOf(month);
                c2 = dateString.charAt(i2);
                month = new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append(c2).toString();
                continue;
            }
            if (chr != 'Y') continue;
            string2 = String.valueOf(year);
            c2 = dateString.charAt(i2);
            year = new StringBuilder(1 + String.valueOf(string2).length()).append(string2).append(c2).toString();
        }
        Preconditions.checkArgument(day.length() == 2, "Date string format exception. Date string's day field must have two chars.");
        Preconditions.checkArgument(month.length() == 2, "Date string format exception. Date string's month field must have two chars.");
        Preconditions.checkArgument(year.length() == 4, "Date string format exception. Date string's years field must have four chars.");
        int iday = Integer.parseInt(day);
        int imonth = Integer.parseInt(month) - 1;
        int iyear = Integer.parseInt(year);
        GregorianCalendar calendar2 = new GregorianCalendar(iyear, imonth, iday);
        return calendar2.getTime();
    }
}

