/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.zylib.ZyTree;

import com.google.security.zynamics.zylib.ZyTree.IZyTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.Stack;

public class InorderIterator {
    private final Stack<Pair<IZyTreeNode, Integer>> traversalStack = new Stack();
    private final IZyTreeNode m_root;
    private boolean m_started = false;

    public InorderIterator(IZyTreeNode root) {
        this.m_root = root;
    }

    private void pushLongestPathFrom(IZyTreeNode node) {
        IZyTreeNode current = node;
        while (true) {
            this.traversalStack.push(new Pair<IZyTreeNode, Integer>(current, 0));
            if (current.getChildren().size() == 0) break;
            current = current.getChildren().get(0);
        }
    }

    public IZyTreeNode current() {
        return (IZyTreeNode)((Pair)this.traversalStack.lastElement()).first();
    }

    public boolean next() {
        if (!this.m_started) {
            this.pushLongestPathFrom(this.m_root);
            this.m_started = true;
        } else {
            if (this.traversalStack.empty()) {
                throw new RuntimeException("Internal Error: Traversal already finished");
            }
            Pair<IZyTreeNode, Integer> justProcessed = this.traversalStack.pop();
            IZyTreeNode justProcessedNode = justProcessed.first();
            int justProcessedChildrenProcessed = justProcessed.second();
            if (this.traversalStack.empty()) {
                if (justProcessedChildrenProcessed == justProcessedNode.getChildren().size()) {
                    return false;
                }
                this.checkAndPush(justProcessed, justProcessedNode, justProcessedChildrenProcessed);
            } else if (justProcessedChildrenProcessed == justProcessedNode.getChildren().size()) {
                Pair<IZyTreeNode, Integer> parentProcessed = this.traversalStack.pop();
                this.traversalStack.push(new Pair<IZyTreeNode, Integer>(parentProcessed.first(), parentProcessed.second() + 1));
            } else {
                this.checkAndPush(justProcessed, justProcessedNode, justProcessedChildrenProcessed);
            }
        }
        return !this.traversalStack.empty();
    }

    private void checkAndPush(Pair<IZyTreeNode, Integer> justProcessed, IZyTreeNode justProcessedNode, int justProcessedChildrenProcessed) {
        switch (justProcessedNode.getChildren().size()) {
            case 0: {
                throw new RuntimeException("Error");
            }
            case 1: {
                this.pushLongestPathFrom(justProcessed.first().getChildren().get(justProcessedChildrenProcessed));
                break;
            }
            default: {
                this.traversalStack.push(new Pair<IZyTreeNode, Integer>(justProcessed.first().getChildren().get(justProcessedChildrenProcessed), 0));
            }
        }
    }
}

