/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class SubTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "sub");
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a sub instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree operand1 = operands.get(0);
        IOperandTree operand2 = operands.get(1);
        TranslationResult operand2Result = Helpers.translateOperand(environment, offset, operand2, true);
        instructions.addAll(operand2Result.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult operand1Result = Helpers.translateOperand(environment, offset, operand1, true);
        instructions.addAll(operand1Result.getInstructions());
        offset = baseOffset + (long)instructions.size();
        OperandSize size = operand1Result.getSize();
        String register1 = operand1Result.getRegister();
        String register2 = operand2Result.getRegister();
        String subResultValue = Helpers.generateSub(environment, offset, size, register1, register2, instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.writeBack(environment, offset, operand1, subResultValue, size, operand1Result.getAddress(), operand1Result.getType(), instructions);
    }
}

