/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.x86.StosGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class StoswTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "stosw");
        if (instruction.getOperands().size() != 0) {
            throw new InternalTranslationException("Error: Argument instruction is not a stosw instruction (invalid number of operand)");
        }
        new StosGenerator().generate(environment, ReilHelpers.toReilAddress(instruction.getAddress()).toLong(), OperandSize.WORD, instructions);
    }
}

