/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.TranslationResultType;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class ShrdTranslator
implements IInstructionTranslator {
    private String getAllButMask(OperandSize extendedSize, OperandSize combinedSize) {
        if (extendedSize == OperandSize.QWORD) {
            return String.valueOf(-4294967296L);
        }
        return String.valueOf(TranslationHelpers.getAllButMask(extendedSize, combinedSize));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "shrd");
        if (instruction.getOperands().size() != 3) {
            throw new InternalTranslationException("Error: Argument instruction is not a shrd instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        TranslationResult firstResult = Helpers.translateOperand(environment, offset, operands.get(0), true);
        instructions.addAll(firstResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult secondResult = Helpers.translateOperand(environment, offset, operands.get(1), true);
        instructions.addAll(secondResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult thirdResult = Helpers.translateOperand(environment, offset, operands.get(2), true);
        instructions.addAll(thirdResult.getInstructions());
        String truncatedShiftValue = environment.getNextVariableString();
        String truncatedShiftValueZero = environment.getNextVariableString();
        offset = baseOffset + (long)instructions.size();
        instructions.add(ReilHelpers.createAnd(offset++, thirdResult.getSize(), thirdResult.getRegister(), OperandSize.BYTE, "31", OperandSize.BYTE, truncatedShiftValue));
        instructions.add(ReilHelpers.createBisz(offset++, OperandSize.BYTE, truncatedShiftValue, OperandSize.BYTE, truncatedShiftValueZero));
        int jumpInsertIndex1 = (int)(offset - baseOffset);
        ++offset;
        instructions.add(ReilHelpers.createUndef(offset++, OperandSize.BYTE, "AF"));
        String sizeSubtractionResult = environment.getNextVariableString();
        String sizeMaskingResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(offset++, OperandSize.BYTE, String.valueOf(firstResult.getSize().getBitSize()), OperandSize.BYTE, truncatedShiftValue, OperandSize.WORD, sizeSubtractionResult));
        instructions.add(ReilHelpers.createAnd(offset++, OperandSize.WORD, sizeSubtractionResult, OperandSize.WORD, String.valueOf(32768), OperandSize.WORD, sizeMaskingResult));
        int jumpInsertIndex2 = (int)(offset - baseOffset);
        ++offset;
        String shiftedSecondInput = environment.getNextVariableString();
        String shiftMask = String.valueOf(firstResult.getSize().getBitSize());
        OperandSize combinedSize = TranslationHelpers.getNextSize(firstResult.getSize());
        OperandSize extendedSize = TranslationHelpers.getNextSize(combinedSize);
        String combinedSource = environment.getNextVariableString();
        String shiftedResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(offset++, secondResult.getSize(), secondResult.getRegister(), secondResult.getSize(), shiftMask, combinedSize, shiftedSecondInput));
        instructions.add(ReilHelpers.createOr(offset++, combinedSize, shiftedSecondInput, firstResult.getSize(), firstResult.getRegister(), combinedSize, combinedSource));
        String negatedShiftMask = environment.getNextVariableString();
        String truncatedNegatedShiftMask = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(offset++, OperandSize.BYTE, "0", OperandSize.BYTE, truncatedShiftValue, OperandSize.WORD, negatedShiftMask));
        instructions.add(ReilHelpers.createAnd(offset++, OperandSize.WORD, negatedShiftMask, OperandSize.BYTE, "255", OperandSize.BYTE, truncatedNegatedShiftMask));
        String incShiftMaskNeg = environment.getNextVariableString();
        String decResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAdd(offset++, OperandSize.BYTE, truncatedNegatedShiftMask, OperandSize.BYTE, "1", OperandSize.WORD, incShiftMaskNeg));
        instructions.add(ReilHelpers.createBsh(offset++, combinedSize, combinedSource, OperandSize.WORD, incShiftMaskNeg, combinedSize, decResult));
        instructions.add(ReilHelpers.createAnd(offset++, combinedSize, decResult, OperandSize.BYTE, "1", OperandSize.BYTE, "CF"));
        instructions.add(ReilHelpers.createBsh(offset++, combinedSize, combinedSource, OperandSize.BYTE, truncatedNegatedShiftMask, extendedSize, shiftedResult));
        String isolationMask = this.getAllButMask(combinedSize, firstResult.getSize());
        String isolationResult = environment.getNextVariableString();
        String shiftedIsolationResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(offset++, extendedSize, shiftedResult, combinedSize, isolationMask, combinedSize, isolationResult));
        long l2 = offset++;
        String string2 = String.valueOf(shiftMask);
        instructions.add(ReilHelpers.createBsh(l2, combinedSize, isolationResult, OperandSize.BYTE, string2.length() != 0 ? "-".concat(string2) : new String("-"), firstResult.getSize(), shiftedIsolationResult));
        instructions.add(ReilHelpers.createBisz(offset++, firstResult.getSize(), shiftedIsolationResult, OperandSize.BYTE, "ZF"));
        Helpers.generateSignFlagCode(environment, offset, shiftedIsolationResult, firstResult.getSize(), instructions);
        offset = baseOffset + (long)instructions.size() + 2L;
        String tempInput = environment.getNextVariableString();
        instructions.add(ReilHelpers.createStr(offset++, firstResult.getSize(), firstResult.getRegister(), firstResult.getSize(), tempInput));
        Helpers.writeBack(environment, offset, operands.get(0), shiftedIsolationResult, firstResult.getSize(), firstResult.getAddress(), firstResult.getType(), instructions);
        offset = baseOffset + (long)instructions.size() + 2L;
        String shiftValueOne = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(offset++, OperandSize.BYTE, truncatedShiftValue, OperandSize.BYTE, "1", OperandSize.WORD, shiftValueOne));
        int jumpInsertIndex3 = (int)(offset - baseOffset);
        ++offset;
        String xoredMsb = environment.getNextVariableString();
        String maskedMsb = environment.getNextVariableString();
        long msbMask = TranslationHelpers.getMsbMask(firstResult.getSize());
        long msbShift = TranslationHelpers.getShiftMsbLsbMask(firstResult.getSize());
        instructions.add(ReilHelpers.createXor(offset++, firstResult.getSize(), tempInput, firstResult.getSize(), shiftedIsolationResult, firstResult.getSize(), xoredMsb));
        instructions.add(ReilHelpers.createAnd(offset++, firstResult.getSize(), xoredMsb, OperandSize.BYTE, String.valueOf(msbMask), OperandSize.BYTE, maskedMsb));
        instructions.add(ReilHelpers.createBsh(offset++, firstResult.getSize(), maskedMsb, OperandSize.BYTE, String.valueOf(msbShift), OperandSize.BYTE, "OF"));
        int jumpInsertIndex4 = (int)(offset - baseOffset);
        String largeValueHandler = String.format("%d.%d", instruction.getAddress().toLong(), ++offset - baseOffset);
        IOperandTree inputOperand = operands.get(0);
        if (firstResult.getType() == TranslationResultType.REGISTER) {
            String operand = Helpers.getLeafValue(inputOperand.getRootNode());
            String undefRegister = Helpers.getOperandSize(inputOperand) == environment.getArchitectureSize() ? operand : Helpers.getParentRegister(operand);
            instructions.add(ReilHelpers.createUndef(offset++, environment.getArchitectureSize(), undefRegister));
        }
        instructions.add(ReilHelpers.createUndef(offset++, OperandSize.BYTE, "CF"));
        instructions.add(ReilHelpers.createUndef(offset++, OperandSize.BYTE, "SF"));
        instructions.add(ReilHelpers.createUndef(offset++, OperandSize.BYTE, "ZF"));
        instructions.add(ReilHelpers.createUndef(offset++, OperandSize.BYTE, "PF"));
        String notOneHandler = String.format("%d.%d", instruction.getAddress().toLong(), offset - baseOffset);
        instructions.add(ReilHelpers.createUndef(offset++, OperandSize.BYTE, "OF"));
        String jmpGoalEnd = String.format("%d.%d", instruction.getAddress().toLong(), offset - baseOffset);
        instructions.add(ReilHelpers.createNop(offset++));
        instructions.add(jumpInsertIndex1, ReilHelpers.createJcc(baseOffset + (long)jumpInsertIndex1, OperandSize.BYTE, truncatedShiftValueZero, OperandSize.ADDRESS, jmpGoalEnd, new String[0]));
        instructions.add(jumpInsertIndex2, ReilHelpers.createJcc(baseOffset + (long)jumpInsertIndex2, OperandSize.WORD, sizeMaskingResult, OperandSize.ADDRESS, largeValueHandler, new String[0]));
        instructions.add(jumpInsertIndex3, ReilHelpers.createJcc(baseOffset + (long)jumpInsertIndex3, OperandSize.WORD, shiftValueOne, OperandSize.ADDRESS, notOneHandler, new String[0]));
        instructions.add(jumpInsertIndex4, ReilHelpers.createJcc(baseOffset + (long)jumpInsertIndex4, OperandSize.BYTE, "1", OperandSize.ADDRESS, jmpGoalEnd, new String[0]));
    }
}

