/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.ArrayList;
import java.util.List;

public class ShrTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long reilOffsetBase;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "shr");
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a shr instruction (invalid number of operands)");
        }
        long offset = reilOffsetBase = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        TranslationResult firstResult = Helpers.translateOperand(environment, offset, operands.get(0), true);
        instructions.addAll(firstResult.getInstructions());
        offset = reilOffsetBase + (long)instructions.size();
        TranslationResult secondResult = Helpers.translateOperand(environment, offset, operands.get(1), true);
        instructions.addAll(secondResult.getInstructions());
        offset = reilOffsetBase + (long)instructions.size();
        OperandSize size1 = firstResult.getSize();
        OperandSize size2 = secondResult.getSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(size1);
        String operand1 = firstResult.getRegister();
        String operand2 = secondResult.getRegister();
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(size1));
        String modValue = String.valueOf(size1.getBitSize());
        String shiftMask = environment.getNextVariableString();
        String shiftMaskZero = environment.getNextVariableString();
        String shiftMaskLessOne = environment.getNextVariableString();
        String shiftMaskOne = environment.getNextVariableString();
        String shiftMaskNeg = environment.getNextVariableString();
        String result = environment.getNextVariableString();
        String truncatedResult = environment.getNextVariableString();
        String incShiftMaskNeg = environment.getNextVariableString();
        String decResult = environment.getNextVariableString();
        int before = instructions.size();
        ArrayList<ReilInstruction> writebackInstructions = new ArrayList<ReilInstruction>();
        Helpers.writeBack(environment, offset + 17L, operands.get(0), truncatedResult, size1, firstResult.getAddress(), firstResult.getType(), writebackInstructions);
        instructions.add(ReilHelpers.createMod(offset, size2, operand2, size2, modValue, size2, shiftMask));
        instructions.add(ReilHelpers.createBisz(offset + 1L, size2, shiftMask, OperandSize.BYTE, shiftMaskZero));
        instructions.add(ReilHelpers.createSub(offset + 2L, size2, "1", size2, shiftMask, size2, shiftMaskLessOne));
        instructions.add(ReilHelpers.createBisz(offset + 3L, size2, shiftMaskLessOne, OperandSize.BYTE, shiftMaskOne));
        instructions.add(ReilHelpers.createSub(offset + 4L, size2, "0", size2, shiftMask, size2, shiftMaskNeg));
        instructions.add(ReilHelpers.createBsh(offset + 5L, size1, operand1, size2, shiftMaskNeg, resultSize, result));
        instructions.add(ReilHelpers.createAnd(offset + 6L, resultSize, result, size1, truncateMask, size1, truncatedResult));
        String jmpGoalWriteBack = String.format("%d.%d", instruction.getAddress().toLong(), before + 17);
        instructions.add(ReilHelpers.createJcc(offset + 7L, OperandSize.BYTE, shiftMaskZero, OperandSize.ADDRESS, jmpGoalWriteBack, new String[0]));
        instructions.add(ReilHelpers.createStr(offset + 8L, OperandSize.BYTE, "0", OperandSize.BYTE, "SF"));
        instructions.add(ReilHelpers.createAdd(offset + 9L, size2, shiftMaskNeg, size2, "1", size2, incShiftMaskNeg));
        instructions.add(ReilHelpers.createBsh(offset + 10L, size1, operand1, size2, incShiftMaskNeg, size1, decResult));
        instructions.add(ReilHelpers.createAnd(offset + 11L, size1, decResult, OperandSize.BYTE, "1", OperandSize.BYTE, "CF"));
        instructions.add(ReilHelpers.createBisz(offset + 12L, size1, truncatedResult, OperandSize.BYTE, "ZF"));
        String jmpGoal2 = String.format("%d.%d", instruction.getAddress().toLong(), before + 16);
        instructions.add(ReilHelpers.createJcc(offset + 13L, OperandSize.BYTE, shiftMaskOne, OperandSize.ADDRESS, jmpGoal2, new String[0]));
        instructions.add(ReilHelpers.createUndef(offset + 14L, OperandSize.BYTE, "OF"));
        instructions.add(ReilHelpers.createJcc(offset + 15L, OperandSize.BYTE, "1", OperandSize.ADDRESS, jmpGoalWriteBack, new String[0]));
        instructions.add(ReilHelpers.createXor(offset + 16L, OperandSize.BYTE, "SF", OperandSize.BYTE, "CF", OperandSize.BYTE, "OF"));
        instructions.addAll(writebackInstructions);
    }
}

