/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.ArrayList;
import java.util.List;

public class ShlTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        if (!instruction.getMnemonic().equals("shl") && !instruction.getMnemonic().equals("sal")) {
            throw new InternalTranslationException("Error: Argument instruction is not a shl instruction (wrong mnemonic)");
        }
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a shl instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        TranslationResult firstResult = Helpers.translateOperand(environment, offset, operands.get(0), true);
        instructions.addAll(firstResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult secondResult = Helpers.translateOperand(environment, offset, operands.get(1), true);
        instructions.addAll(secondResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        OperandSize size1 = firstResult.getSize();
        OperandSize size2 = secondResult.getSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(size1);
        String operand1 = firstResult.getRegister();
        String operand2 = secondResult.getRegister();
        String shiftMsbLsbValue = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(size1));
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(size1));
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(size1));
        String modValue = String.valueOf(size1.getBitSize());
        String carryMask = String.valueOf(Helpers.getCarryMask(size1));
        String shiftCarryValue = String.valueOf(-size1.getBitSize());
        String shiftMask = environment.getNextVariableString();
        String shiftMaskZero = environment.getNextVariableString();
        String shiftMaskLessOne = environment.getNextVariableString();
        String shiftMaskOne = environment.getNextVariableString();
        String result = environment.getNextVariableString();
        String truncatedResult = environment.getNextVariableString();
        String msbResult = environment.getNextVariableString();
        String carryResult = environment.getNextVariableString();
        int before = instructions.size();
        ArrayList<ReilInstruction> writebackInstructions = new ArrayList<ReilInstruction>();
        Helpers.writeBack(environment, offset + 16L, operands.get(0), truncatedResult, size1, firstResult.getAddress(), firstResult.getType(), writebackInstructions);
        instructions.add(ReilHelpers.createMod(offset, size2, operand2, size2, modValue, size2, shiftMask));
        instructions.add(ReilHelpers.createBisz(offset + 1L, size2, shiftMask, OperandSize.BYTE, shiftMaskZero));
        instructions.add(ReilHelpers.createSub(offset + 2L, size2, "1", size2, shiftMask, size2, shiftMaskLessOne));
        instructions.add(ReilHelpers.createBisz(offset + 3L, size2, shiftMaskLessOne, OperandSize.BYTE, shiftMaskOne));
        instructions.add(ReilHelpers.createBsh(offset + 4L, size1, operand1, size2, shiftMask, resultSize, result));
        instructions.add(ReilHelpers.createAnd(offset + 5L, resultSize, result, size1, truncateMask, size1, truncatedResult));
        String jmpGoalWriteBack = String.format("%d.%d", instruction.getAddress().toLong(), before + 16);
        instructions.add(ReilHelpers.createJcc(offset + 6L, OperandSize.BYTE, shiftMaskZero, OperandSize.ADDRESS, jmpGoalWriteBack, new String[0]));
        instructions.add(ReilHelpers.createAnd(offset + 7L, resultSize, result, resultSize, msbMask, resultSize, msbResult));
        instructions.add(ReilHelpers.createBsh(offset + 8L, resultSize, msbResult, resultSize, shiftMsbLsbValue, OperandSize.BYTE, "SF"));
        instructions.add(ReilHelpers.createAnd(offset + 9L, resultSize, result, resultSize, carryMask, resultSize, carryResult));
        instructions.add(ReilHelpers.createBsh(offset + 10L, resultSize, carryResult, resultSize, shiftCarryValue, OperandSize.BYTE, "CF"));
        instructions.add(ReilHelpers.createBisz(offset + 11L, size1, truncatedResult, OperandSize.BYTE, "ZF"));
        String jmpGoal2 = String.format("%d.%d", instruction.getAddress().toLong(), before + 15);
        instructions.add(ReilHelpers.createJcc(offset + 12L, OperandSize.BYTE, shiftMaskOne, OperandSize.ADDRESS, jmpGoal2, new String[0]));
        instructions.add(ReilHelpers.createUndef(offset + 13L, OperandSize.BYTE, "OF"));
        instructions.add(ReilHelpers.createJcc(offset + 14L, OperandSize.BYTE, "1", OperandSize.ADDRESS, jmpGoalWriteBack, new String[0]));
        instructions.add(ReilHelpers.createXor(offset + 15L, OperandSize.BYTE, "SF", OperandSize.BYTE, "CF", OperandSize.BYTE, "OF"));
        instructions.addAll(writebackInstructions);
    }
}

