/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class SbbTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "sbb");
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a sbb instruction (invalid number of operand)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree targetOperand = operands.get(0);
        IOperandTree sourceOperand = operands.get(1);
        TranslationResult sourceResult = Helpers.translateOperand(environment, offset, sourceOperand, true);
        instructions.addAll(sourceResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult targetResult = Helpers.translateOperand(environment, offset, targetOperand, true);
        instructions.addAll(targetResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        if (sourceResult.getSize() != targetResult.getSize()) {
            throw new InternalTranslationException("Error: The operands of SBB instructions must have equal size");
        }
        OperandSize size = sourceResult.getSize();
        String sourceRegister = sourceResult.getRegister();
        String targetRegister = targetResult.getRegister();
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(size));
        String carryMask = String.valueOf(Helpers.getCarryMask(size));
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(size));
        String shiftValue = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(size));
        String shiftCarry = String.valueOf(-size.getBitSize());
        OperandSize resultSize = TranslationHelpers.getNextSize(size);
        String msb1 = environment.getNextVariableString();
        String msb2 = environment.getNextVariableString();
        String subResult = environment.getNextVariableString();
        String subResultTemp = environment.getNextVariableString();
        String msbResult = environment.getNextVariableString();
        String msbSameBefore = environment.getNextVariableString();
        String msbChanged = environment.getNextVariableString();
        String tempOf = environment.getNextVariableString();
        String tempCf = environment.getNextVariableString();
        String truncatedResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(offset, size, sourceRegister, size, msbMask, size, msb1));
        instructions.add(ReilHelpers.createAnd(offset + 1L, size, targetRegister, size, msbMask, size, msb2));
        instructions.add(ReilHelpers.createSub(offset + 2L, size, sourceRegister, size, targetRegister, resultSize, subResultTemp));
        instructions.add(ReilHelpers.createSub(offset + 3L, resultSize, subResultTemp, OperandSize.BYTE, "CF", resultSize, subResult));
        instructions.add(ReilHelpers.createAnd(offset + 4L, resultSize, subResult, resultSize, msbMask, size, msbResult));
        instructions.add(ReilHelpers.createBsh(offset + 5L, size, msbResult, size, shiftValue, OperandSize.BYTE, "SF"));
        instructions.add(ReilHelpers.createXor(offset + 6L, size, msb1, size, msb2, size, msbSameBefore));
        instructions.add(ReilHelpers.createXor(offset + 7L, size, msb1, size, msbResult, size, msbChanged));
        instructions.add(ReilHelpers.createAnd(offset + 8L, size, msbSameBefore, size, msbChanged, size, tempOf));
        instructions.add(ReilHelpers.createBsh(offset + 9L, size, tempOf, size, shiftValue, OperandSize.BYTE, "OF"));
        instructions.add(ReilHelpers.createAnd(offset + 10L, resultSize, subResult, resultSize, carryMask, resultSize, tempCf));
        instructions.add(ReilHelpers.createBsh(offset + 11L, resultSize, tempCf, resultSize, shiftCarry, OperandSize.BYTE, "CF"));
        instructions.add(ReilHelpers.createAnd(offset + 12L, resultSize, subResult, resultSize, truncateMask, size, truncatedResult));
        instructions.add(ReilHelpers.createBisz(offset + 13L, size, truncatedResult, OperandSize.BYTE, "ZF"));
        Helpers.writeBack(environment, offset + 14L, targetOperand, truncatedResult, size, targetResult.getAddress(), targetResult.getType(), instructions);
    }
}

