/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class RorTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a ror instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree targetOperand = operands.get(0);
        IOperandTree sourceOperand = operands.get(1);
        TranslationResult sourceResult = Helpers.translateOperand(environment, offset, sourceOperand, true);
        instructions.addAll(sourceResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult targetResult = Helpers.translateOperand(environment, offset, targetOperand, true);
        instructions.addAll(targetResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        int linesBefore = instructions.size();
        OperandSize sourceSize = sourceResult.getSize();
        OperandSize targetSize = targetResult.getSize();
        String sourceRegister = sourceResult.getRegister();
        String targetRegister = targetResult.getRegister();
        String rotateMask = environment.getNextVariableString();
        String rotateMaskZero = environment.getNextVariableString();
        String rotateMaskLessOne = environment.getNextVariableString();
        String rotateMaskOne = environment.getNextVariableString();
        String shrValue = environment.getNextVariableString();
        String shredResult = environment.getNextVariableString();
        String shlValue = environment.getNextVariableString();
        String shledResult = environment.getNextVariableString();
        String result = environment.getNextVariableString();
        String tempCf = environment.getNextVariableString();
        String tempOf = environment.getNextVariableString();
        String tempOfLsb = environment.getNextVariableString();
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(targetSize));
        String modVal = String.valueOf(targetSize.getBitSize());
        String msbMask2nd = String.valueOf(TranslationHelpers.getMsbMask(targetSize) / 2L);
        String shiftMsbLsb = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(targetSize));
        String shift2ndMsbLsb = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(sourceSize) / 2L);
        instructions.add(ReilHelpers.createMod(offset, sourceSize, sourceRegister, targetSize, modVal, targetSize, rotateMask));
        instructions.add(ReilHelpers.createBisz(offset + 1L, targetSize, rotateMask, OperandSize.BYTE, rotateMaskZero));
        instructions.add(ReilHelpers.createSub(offset + 2L, targetSize, rotateMask, targetSize, "1", targetSize, rotateMaskLessOne));
        instructions.add(ReilHelpers.createBisz(offset + 3L, targetSize, rotateMaskLessOne, OperandSize.BYTE, rotateMaskOne));
        instructions.add(ReilHelpers.createSub(offset + 4L, OperandSize.BYTE, "0", OperandSize.BYTE, rotateMask, OperandSize.BYTE, shrValue));
        instructions.add(ReilHelpers.createBsh(offset + 5L, targetSize, targetRegister, OperandSize.BYTE, shrValue, targetSize, shredResult));
        instructions.add(ReilHelpers.createSub(offset + 6L, OperandSize.BYTE, modVal, OperandSize.BYTE, rotateMask, OperandSize.BYTE, shlValue));
        instructions.add(ReilHelpers.createBsh(offset + 7L, targetSize, targetRegister, OperandSize.BYTE, shlValue, targetSize, shledResult));
        instructions.add(ReilHelpers.createOr(offset + 8L, targetSize, shredResult, targetSize, shledResult, targetSize, result));
        String jmpGoal = String.format("%d.%d", instruction.getAddress().toLong(), linesBefore + 18);
        instructions.add(ReilHelpers.createJcc(offset + 9L, OperandSize.BYTE, rotateMaskZero, OperandSize.ADDRESS, jmpGoal, new String[0]));
        instructions.add(ReilHelpers.createAnd(offset + 10L, targetSize, result, targetSize, msbMask, targetSize, tempCf));
        instructions.add(ReilHelpers.createBsh(offset + 11L, targetSize, tempCf, targetSize, shiftMsbLsb, OperandSize.BYTE, "CF"));
        String jmpGoal2 = String.format("%d.%d", instruction.getAddress().toLong(), linesBefore + 15);
        instructions.add(ReilHelpers.createJcc(offset + 12L, OperandSize.BYTE, rotateMaskOne, OperandSize.ADDRESS, jmpGoal2, new String[0]));
        instructions.add(ReilHelpers.createUndef(offset + 13L, OperandSize.BYTE, "OF"));
        String jmpGoal3 = String.format("%d.%d", instruction.getAddress().toLong(), linesBefore + 18);
        instructions.add(ReilHelpers.createJcc(offset + 14L, OperandSize.BYTE, "1", OperandSize.ADDRESS, jmpGoal3, new String[0]));
        instructions.add(ReilHelpers.createAnd(offset + 15L, targetSize, result, targetSize, msbMask2nd, targetSize, tempOf));
        instructions.add(ReilHelpers.createBsh(offset + 16L, targetSize, tempOf, targetSize, shift2ndMsbLsb, OperandSize.BYTE, tempOfLsb));
        instructions.add(ReilHelpers.createBsh(offset + 17L, OperandSize.BYTE, tempOfLsb, OperandSize.BYTE, "CF", OperandSize.BYTE, "OF"));
        Helpers.writeBack(environment, offset + 18L, targetOperand, result, targetResult.getSize(), targetResult.getAddress(), targetResult.getType(), instructions);
    }
}

