/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class RolTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "rol");
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a rol instruction (invalid number of operand)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree targetOperand = operands.get(0);
        IOperandTree sourceOperand = operands.get(1);
        TranslationResult sourceResult = Helpers.translateOperand(environment, offset, sourceOperand, true);
        instructions.addAll(sourceResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult targetResult = Helpers.translateOperand(environment, offset, targetOperand, true);
        instructions.addAll(targetResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        OperandSize sourceSize = sourceResult.getSize();
        OperandSize targetSize = targetResult.getSize();
        String sourceRegister = sourceResult.getRegister();
        String targetRegister = targetResult.getRegister();
        String rotateMask = environment.getNextVariableString();
        String rotateMaskZero = environment.getNextVariableString();
        String rotateMaskLessOne = environment.getNextVariableString();
        String rotateMaskOne = environment.getNextVariableString();
        String shrValue = environment.getNextVariableString();
        String shredResult = environment.getNextVariableString();
        String shledResult = environment.getNextVariableString();
        String result = environment.getNextVariableString();
        String tempOf = environment.getNextVariableString();
        String tempOfLsb = environment.getNextVariableString();
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(targetSize));
        String modVal = String.valueOf(targetSize.getBitSize());
        String shiftMsbLsb = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(targetSize));
        int linesBefore = instructions.size();
        instructions.add(ReilHelpers.createMod(offset, sourceSize, sourceRegister, targetSize, modVal, targetSize, rotateMask));
        instructions.add(ReilHelpers.createBisz(offset + 1L, targetSize, rotateMask, OperandSize.BYTE, rotateMaskZero));
        instructions.add(ReilHelpers.createSub(offset + 2L, targetSize, rotateMask, targetSize, "1", targetSize, rotateMaskLessOne));
        instructions.add(ReilHelpers.createBisz(offset + 3L, targetSize, rotateMaskLessOne, OperandSize.BYTE, rotateMaskOne));
        instructions.add(ReilHelpers.createBsh(offset + 4L, targetSize, targetRegister, OperandSize.BYTE, rotateMask, targetSize, shledResult));
        String string2 = String.valueOf(modVal);
        instructions.add(ReilHelpers.createAdd(offset + 5L, OperandSize.BYTE, string2.length() != 0 ? "-".concat(string2) : new String("-"), OperandSize.BYTE, rotateMask, OperandSize.BYTE, shrValue));
        instructions.add(ReilHelpers.createBsh(offset + 6L, targetSize, targetRegister, OperandSize.BYTE, shrValue, targetSize, shredResult));
        instructions.add(ReilHelpers.createOr(offset + 7L, targetSize, shledResult, targetSize, shredResult, targetSize, result));
        String jmpGoal = String.format("%d.%d", instruction.getAddress().toLong(), linesBefore + 16);
        instructions.add(ReilHelpers.createJcc(offset + 8L, OperandSize.BYTE, rotateMaskZero, OperandSize.ADDRESS, jmpGoal, new String[0]));
        instructions.add(ReilHelpers.createAnd(offset + 9L, targetSize, result, sourceSize, "1", OperandSize.BYTE, "CF"));
        String jmpGoal2 = String.format("%d.%d", instruction.getAddress().toLong(), linesBefore + 13);
        instructions.add(ReilHelpers.createJcc(offset + 10L, OperandSize.BYTE, rotateMaskOne, OperandSize.ADDRESS, jmpGoal2, new String[0]));
        instructions.add(ReilHelpers.createUndef(offset + 11L, OperandSize.BYTE, "OF"));
        String jmpGoal3 = String.format("%d.%d", instruction.getAddress().toLong(), linesBefore + 16);
        instructions.add(ReilHelpers.createJcc(offset + 12L, OperandSize.BYTE, "1", OperandSize.ADDRESS, jmpGoal3, new String[0]));
        instructions.add(ReilHelpers.createAnd(offset + 13L, targetSize, result, targetSize, msbMask, sourceSize, tempOf));
        instructions.add(ReilHelpers.createBsh(offset + 14L, targetSize, tempOf, targetSize, shiftMsbLsb, OperandSize.BYTE, tempOfLsb));
        instructions.add(ReilHelpers.createBsh(offset + 15L, OperandSize.BYTE, tempOfLsb, OperandSize.BYTE, "CF", OperandSize.BYTE, "OF"));
        Helpers.writeBack(environment, offset + 16L, targetOperand, result, targetResult.getSize(), targetResult.getAddress(), targetResult.getType(), instructions);
    }
}

