/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.x86.IStringInstructionGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.ArrayList;
import java.util.List;

public class RepeTranslator
implements IInstructionTranslator {
    private final IStringInstructionGenerator translator;
    private final OperandSize operandSize;

    public RepeTranslator(IStringInstructionGenerator translator, OperandSize operandSize) {
        this.translator = translator;
        this.operandSize = operandSize;
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        OperandSize archSize = environment.getArchitectureSize();
        String invertedEcx = environment.getNextVariableString();
        ArrayList<ReilInstruction> innerInstructions = new ArrayList<ReilInstruction>();
        this.translator.generate(environment, ReilHelpers.toReilAddress(instruction.getAddress()).toLong() + 2L, this.operandSize, innerInstructions);
        String firstInstruction = String.format("%d.0", instruction.getAddress().toLong());
        String jmpGoal = String.format("%d.%d", instruction.getAddress().toLong(), innerInstructions.size() + 6);
        instructions.add(ReilHelpers.createBisz(offset, archSize, "ecx", OperandSize.BYTE, invertedEcx));
        instructions.add(ReilHelpers.createJcc(offset + 1L, OperandSize.BYTE, invertedEcx, OperandSize.ADDRESS, jmpGoal, new String[0]));
        instructions.addAll(innerInstructions);
        String decrementedEcx = environment.getNextVariableString();
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(OperandSize.DWORD));
        instructions.add(ReilHelpers.createSub(baseOffset + (long)instructions.size(), OperandSize.DWORD, "ecx", OperandSize.DWORD, "1", OperandSize.QWORD, decrementedEcx));
        instructions.add(ReilHelpers.createAnd(baseOffset + (long)instructions.size(), OperandSize.QWORD, decrementedEcx, OperandSize.DWORD, truncateMask, OperandSize.DWORD, "ecx"));
        instructions.add(ReilHelpers.createJcc(baseOffset + (long)instructions.size(), OperandSize.DWORD, "ZF", OperandSize.ADDRESS, firstInstruction, new String[0]));
        instructions.add(ReilHelpers.createNop(baseOffset + (long)instructions.size()));
    }
}

