/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class RcrTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "rcr");
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a rcr instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree targetOperand = operands.get(0);
        IOperandTree sourceOperand = operands.get(1);
        TranslationResult sourceResult = Helpers.translateOperand(environment, offset, sourceOperand, true);
        instructions.addAll(sourceResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult targetResult = Helpers.translateOperand(environment, offset, targetOperand, true);
        instructions.addAll(targetResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        OperandSize sourceSize = sourceResult.getSize();
        OperandSize targetSize = targetResult.getSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(sourceSize);
        String sourceRegister = sourceResult.getRegister();
        String targetRegister = targetResult.getRegister();
        String rotateMask = environment.getNextVariableString();
        String rotateMaskZero = environment.getNextVariableString();
        String rotateMaskLessOne = environment.getNextVariableString();
        String rotateMaskOne = environment.getNextVariableString();
        String shiftedOp1 = environment.getNextVariableString();
        String realOp1 = environment.getNextVariableString();
        String shrValue = environment.getNextVariableString();
        String shredResult = environment.getNextVariableString();
        String shlValue = environment.getNextVariableString();
        String shledResult = environment.getNextVariableString();
        String result = environment.getNextVariableString();
        String shiftedResult = environment.getNextVariableString();
        String truncatedResult = environment.getNextVariableString();
        String tempOf = environment.getNextVariableString();
        String tempOfLsb = environment.getNextVariableString();
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(sourceSize));
        String maskSize = String.valueOf(TranslationHelpers.getAllBitsMask(sourceSize));
        String modVal = String.valueOf(sourceSize.getBitSize());
        String shiftMsbLsb = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(sourceSize));
        instructions.add(ReilHelpers.createMod(offset, targetSize, targetRegister, targetSize, modVal, targetSize, rotateMask));
        instructions.add(ReilHelpers.createBisz(offset + 1L, targetSize, rotateMask, OperandSize.BYTE, rotateMaskZero));
        instructions.add(ReilHelpers.createSub(offset + 2L, targetSize, rotateMask, targetSize, "1", targetSize, rotateMaskLessOne));
        instructions.add(ReilHelpers.createBisz(offset + 3L, targetSize, rotateMaskLessOne, OperandSize.BYTE, rotateMaskOne));
        instructions.add(ReilHelpers.createBsh(offset + 4L, sourceSize, sourceRegister, OperandSize.BYTE, "1", resultSize, shiftedOp1));
        instructions.add(ReilHelpers.createOr(offset + 5L, resultSize, shiftedOp1, OperandSize.BYTE, "CF", resultSize, realOp1));
        instructions.add(ReilHelpers.createSub(offset + 6L, OperandSize.BYTE, "0", OperandSize.BYTE, rotateMask, OperandSize.BYTE, shrValue));
        instructions.add(ReilHelpers.createBsh(offset + 7L, sourceSize, realOp1, OperandSize.BYTE, shrValue, sourceSize, shredResult));
        instructions.add(ReilHelpers.createSub(offset + 8L, OperandSize.BYTE, modVal, OperandSize.BYTE, rotateMask, OperandSize.BYTE, shlValue));
        instructions.add(ReilHelpers.createBsh(offset + 9L, sourceSize, realOp1, OperandSize.BYTE, shlValue, sourceSize, shledResult));
        instructions.add(ReilHelpers.createOr(offset + 10L, sourceSize, shredResult, sourceSize, shledResult, sourceSize, result));
        instructions.add(ReilHelpers.createBsh(offset + 11L, resultSize, result, OperandSize.BYTE, "-1", resultSize, shiftedResult));
        instructions.add(ReilHelpers.createAnd(offset + 12L, resultSize, shiftedResult, sourceSize, maskSize, sourceSize, truncatedResult));
        String jmpGoal = "666";
        instructions.add(ReilHelpers.createJcc(offset + 13L, OperandSize.BYTE, rotateMaskZero, OperandSize.ADDRESS, "666", new String[0]));
        String jmpGoal2 = "666";
        instructions.add(ReilHelpers.createJcc(offset + 14L, OperandSize.BYTE, rotateMaskZero, OperandSize.ADDRESS, "666", new String[0]));
        instructions.add(ReilHelpers.createUndef(offset + 15L, OperandSize.BYTE, "OF"));
        String jmpGoal3 = "666";
        instructions.add(ReilHelpers.createJcc(offset + 15L, OperandSize.BYTE, rotateMaskZero, OperandSize.ADDRESS, "666", new String[0]));
        instructions.add(ReilHelpers.createAnd(offset + 16L, sourceSize, sourceRegister, sourceSize, msbMask, sourceSize, tempOf));
        instructions.add(ReilHelpers.createBsh(offset + 17L, sourceSize, tempOf, sourceSize, shiftMsbLsb, OperandSize.BYTE, tempOfLsb));
        instructions.add(ReilHelpers.createXor(offset + 18L, OperandSize.BYTE, tempOfLsb, OperandSize.BYTE, "CF", OperandSize.BYTE, "OF"));
        instructions.add(ReilHelpers.createAnd(offset + 19L, resultSize, result, OperandSize.BYTE, "1", OperandSize.BYTE, "CF"));
        Helpers.writeBack(environment, offset + 20L, targetOperand, result, targetResult.getSize(), targetResult.getAddress(), targetResult.getType(), instructions);
    }
}

