/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class PushTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        String tempRegister;
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "push");
        if (instruction.getOperands().size() != 1) {
            throw new InternalTranslationException("Error: Argument instruction is not a push instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        IOperandTree operand = instruction.getOperands().get(0);
        TranslationResult result = Helpers.translateOperand(environment, offset, operand, true);
        instructions.addAll(result.getInstructions());
        offset = baseOffset + (long)instructions.size();
        OperandSize resultSize = result.getSize() == OperandSize.BYTE ? OperandSize.DWORD : result.getSize();
        String loadedValue = result.getRegister();
        if (result.getInstructions().isEmpty() && loadedValue.equalsIgnoreCase("esp")) {
            tempRegister = environment.getNextVariableString();
            instructions.add(ReilHelpers.createStr(offset++, resultSize, loadedValue, resultSize, tempRegister));
        } else {
            tempRegister = loadedValue;
        }
        Helpers.generatePush(environment, offset, tempRegister, resultSize, instructions);
    }
}

