/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class PopfTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "popf");
        Preconditions.checkArgument(instruction.getOperands().size() == 0, "Error: Argument instruction is not a popf instruction (invalid number of operand)");
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        String result = environment.getNextVariableString();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.DWORD, result, instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.shiftValueIntoFlags(environment, offset, result, OperandSize.DWORD, instructions);
    }
}

