/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class PopawTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "popaw");
        if (instruction.getOperands().size() != 0) {
            throw new InternalTranslationException("Error: Argument instruction is not a popaw instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        Helpers.generateLoadFromStack(environment, offset, OperandSize.WORD, "edi", instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.WORD, "esi", instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.WORD, "ebp", instructions);
        offset = baseOffset + (long)instructions.size();
        String newEsp = environment.getNextVariableString();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.WORD, newEsp, instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.WORD, "ebx", instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.WORD, "edx", instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.WORD, "ecx", instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.WORD, "eax", instructions);
        offset = baseOffset + (long)instructions.size();
        String maskedEsp = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(offset, OperandSize.DWORD, "esp", OperandSize.DWORD, "4294901760", OperandSize.DWORD, maskedEsp));
        instructions.add(ReilHelpers.createOr(offset + 1L, OperandSize.WORD, newEsp, OperandSize.DWORD, maskedEsp, OperandSize.DWORD, "esp"));
    }
}

