/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class PopaTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "popa");
        if (instruction.getOperands().size() != 0) {
            throw new InternalTranslationException("Error: Argument instruction is not a popa instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        Helpers.generateLoadFromStack(environment, offset, OperandSize.DWORD, "edi", instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.DWORD, "esi", instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.DWORD, "ebp", instructions);
        offset = baseOffset + (long)instructions.size();
        String newEsp = environment.getNextVariableString();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.DWORD, newEsp, instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.DWORD, "ebx", instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.DWORD, "edx", instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.DWORD, "ecx", instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateLoadFromStack(environment, offset, OperandSize.DWORD, "eax", instructions);
        offset = baseOffset + (long)instructions.size();
        instructions.add(ReilHelpers.createStr(offset, OperandSize.DWORD, newEsp, OperandSize.DWORD, "esp"));
    }
}

