/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.TranslationResultType;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class PopTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        if (instruction.getOperands().size() != 1) {
            throw new InternalTranslationException("Error: Argument instruction is not a pop instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        IOperandTree operand = instruction.getOperands().get(0);
        TranslationResult result = Helpers.translateOperand(environment, offset, operand, false);
        TranslationResultType resultType = result.getType();
        OperandSize resultSize = result.getSize();
        instructions.addAll(result.getInstructions());
        offset = baseOffset + (long)instructions.size();
        String popResult = Helpers.generatePop(environment, offset, resultSize, null, instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.writeBack(environment, offset, operand, popResult, resultSize, result.getAddress(), resultType, instructions);
    }
}

