/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.x86.IConditionGenerator;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class NotLessEqualGenerator
implements IConditionGenerator {
    @Override
    public Pair<OperandSize, String> generate(ITranslationEnvironment environment, long offset, List<ReilInstruction> instructions) throws InternalTranslationException {
        if (environment == null) {
            throw new InternalTranslationException("Error: Argument environment cannot be null");
        }
        if (instructions == null) {
            throw new InternalTranslationException("Error: Argument instructions cannot be null");
        }
        if (offset < 0L) {
            throw new InternalTranslationException("Error: Argument offset cannot be less than 0");
        }
        String connected = environment.getNextVariableString();
        String ored = environment.getNextVariableString();
        String negated = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(offset, OperandSize.BYTE, "SF", OperandSize.BYTE, "OF", OperandSize.BYTE, connected));
        instructions.add(ReilHelpers.createOr(offset + 1L, OperandSize.BYTE, connected, OperandSize.BYTE, "ZF", OperandSize.BYTE, ored));
        instructions.add(ReilHelpers.createXor(offset + 2L, OperandSize.BYTE, ored, OperandSize.BYTE, "1", OperandSize.BYTE, negated));
        return new Pair<OperandSize, String>(OperandSize.BYTE, negated);
    }
}

