/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.x86.IConditionGenerator;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class NotBelowEqualGenerator
implements IConditionGenerator {
    @Override
    public Pair<OperandSize, String> generate(ITranslationEnvironment environment, long offset, List<ReilInstruction> instructions) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        Preconditions.checkArgument(offset >= 0L, "Error: Argument offset can't be less than 0");
        String negatedCarry = environment.getNextVariableString();
        String negatedZero = environment.getNextVariableString();
        String result = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(offset, OperandSize.BYTE, "CF", OperandSize.BYTE, "1", OperandSize.BYTE, negatedCarry));
        instructions.add(ReilHelpers.createXor(offset + 1L, OperandSize.BYTE, "OF", OperandSize.BYTE, "1", OperandSize.BYTE, negatedZero));
        instructions.add(ReilHelpers.createAnd(offset + 2L, OperandSize.BYTE, negatedCarry, OperandSize.BYTE, negatedZero, OperandSize.BYTE, result));
        return new Pair<OperandSize, String>(OperandSize.BYTE, result);
    }
}

