/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class NegTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "neg");
        if (instruction.getOperands().size() != 1) {
            throw new InternalTranslationException("Error: Argument instruction is not an neg instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        IOperandTree operand = instruction.getOperands().get(0);
        TranslationResult result = Helpers.translateOperand(environment, offset, operand, true);
        instructions.addAll(result.getInstructions());
        offset = baseOffset + (long)instructions.size();
        String operandRegister = result.getRegister();
        OperandSize size = result.getSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(size);
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(size));
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(size));
        String shiftValue = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(size));
        String targetIsZero = environment.getNextVariableString();
        String msbTarget = environment.getNextVariableString();
        String negResult = environment.getNextVariableString();
        String msbResult = environment.getNextVariableString();
        String tempOf = environment.getNextVariableString();
        String truncatedResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBisz(offset, size, operandRegister, OperandSize.BYTE, targetIsZero));
        instructions.add(ReilHelpers.createBisz(offset + 1L, OperandSize.BYTE, targetIsZero, OperandSize.BYTE, "CF"));
        instructions.add(ReilHelpers.createAnd(offset + 2L, size, operandRegister, size, msbMask, size, msbTarget));
        instructions.add(ReilHelpers.createSub(offset + 3L, size, "0", size, operandRegister, resultSize, negResult));
        instructions.add(ReilHelpers.createAnd(offset + 4L, resultSize, negResult, size, msbMask, size, msbResult));
        instructions.add(ReilHelpers.createBsh(offset + 5L, size, msbResult, size, shiftValue, OperandSize.BYTE, "SF"));
        instructions.add(ReilHelpers.createAnd(offset + 6L, size, msbTarget, size, msbResult, size, tempOf));
        instructions.add(ReilHelpers.createBsh(offset + 7L, size, tempOf, size, shiftValue, OperandSize.BYTE, "OF"));
        instructions.add(ReilHelpers.createAnd(offset + 8L, resultSize, negResult, size, truncateMask, size, truncatedResult));
        instructions.add(ReilHelpers.createBisz(offset + 9L, size, truncatedResult, OperandSize.BYTE, "ZF"));
        Helpers.writeBack(environment, offset + 10L, operand, truncatedResult, size, result.getAddress(), result.getType(), instructions);
    }
}

