/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class MulTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "mul");
        if (instruction.getOperands().size() != 1) {
            throw new InternalTranslationException("Error: Argument instruction is not a mul instruction (invalid number of operand)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        TranslationResult firstResult = Helpers.translateOperand(environment, offset, operands.get(0), true);
        instructions.addAll(firstResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        String operand1 = firstResult.getRegister();
        String operand2 = "eax";
        OperandSize size1 = firstResult.getSize();
        OperandSize size2 = environment.getArchitectureSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(size2);
        String result = environment.getNextVariableString();
        String upperHalf = environment.getNextVariableString();
        String upperHalfZero = environment.getNextVariableString();
        String maskUpper = String.valueOf(TranslationHelpers.getAllButMask(resultSize, size1));
        instructions.add(ReilHelpers.createMul(offset, size1, operand1, size2, "eax", resultSize, result));
        instructions.add(ReilHelpers.createAnd(offset + 1L, resultSize, result, resultSize, maskUpper, resultSize, upperHalf));
        instructions.add(ReilHelpers.createBisz(offset + 2L, resultSize, upperHalf, OperandSize.BYTE, upperHalfZero));
        instructions.add(ReilHelpers.createBisz(offset + 3L, resultSize, upperHalfZero, OperandSize.BYTE, "CF"));
        instructions.add(ReilHelpers.createBisz(offset + 4L, resultSize, upperHalfZero, OperandSize.BYTE, "OF"));
        instructions.add(ReilHelpers.createUndef(offset + 5L, OperandSize.BYTE, "SF"));
        instructions.add(ReilHelpers.createUndef(offset + 6L, OperandSize.BYTE, "ZF"));
        instructions.add(ReilHelpers.createUndef(offset + 7L, OperandSize.BYTE, "AF"));
        instructions.add(ReilHelpers.createUndef(offset + 8L, OperandSize.BYTE, "PF"));
        instructions.addAll(Helpers.writeMulResult(environment, offset + 9L, result, size1));
    }
}

