/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.x86.IStringInstructionGenerator;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.util.List;

public class LodsGenerator
implements IStringInstructionGenerator {
    @Override
    public void generate(ITranslationEnvironment environment, long baseOffset, OperandSize operandSize, List<ReilInstruction> instructions) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        long offset = baseOffset;
        int previousInstructions = (int)(baseOffset % 256L);
        OperandSize archSize = environment.getArchitectureSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(operandSize);
        String ediChange = String.valueOf(operandSize.getByteSize());
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(archSize));
        if (operandSize == archSize) {
            instructions.add(ReilHelpers.createLdm(offset++, archSize, "esi", archSize, "eax"));
        } else {
            String tempLoad = environment.getNextVariableString();
            String maskedEax = environment.getNextVariableString();
            String mask = String.valueOf(TranslationHelpers.getAllButMask(archSize, operandSize));
            instructions.add(ReilHelpers.createLdm(offset++, archSize, "esi", operandSize, tempLoad));
            instructions.add(ReilHelpers.createAnd(offset++, archSize, "eax", archSize, mask, archSize, maskedEax));
            instructions.add(ReilHelpers.createOr(offset++, operandSize, tempLoad, archSize, maskedEax, archSize, "eax"));
        }
        String tempEsi1 = environment.getNextVariableString();
        String tempEsi2 = environment.getNextVariableString();
        int linesBefore = instructions.size();
        String jmpGoal = String.format("%d.%d", ReilHelpers.toNativeAddress(new CAddress(baseOffset)).toLong(), previousInstructions + linesBefore + 4);
        instructions.add(ReilHelpers.createJcc(offset++, OperandSize.BYTE, "DF", OperandSize.ADDRESS, jmpGoal, new String[0]));
        instructions.add(ReilHelpers.createAdd(offset++, archSize, "esi", archSize, ediChange, resultSize, tempEsi1));
        instructions.add(ReilHelpers.createAnd(offset++, resultSize, tempEsi1, archSize, truncateMask, archSize, "esi"));
        String jmpGoal2 = String.format("%d.%d", ReilHelpers.toNativeAddress(new CAddress(baseOffset)).toLong(), previousInstructions + linesBefore + 6);
        instructions.add(ReilHelpers.createJcc(offset++, OperandSize.BYTE, "1", OperandSize.ADDRESS, jmpGoal2, new String[0]));
        instructions.add(ReilHelpers.createSub(offset++, archSize, "esi", archSize, ediChange, resultSize, tempEsi2));
        instructions.add(ReilHelpers.createAnd(offset++, resultSize, tempEsi2, archSize, truncateMask, archSize, "esi"));
        instructions.add(ReilHelpers.createNop(offset));
    }
}

