/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class LeaveTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "leave");
        Preconditions.checkArgument(instruction.getOperands().size() == 0, "Error: Argument instruction is not a leave instruction (invalid number of operands)");
        long baseOffset = instruction.getAddress().toLong() * 256L;
        OperandSize archSize = environment.getArchitectureSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(archSize);
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(archSize));
        String addResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createStr(baseOffset, archSize, "ebp", archSize, "esp"));
        instructions.add(ReilHelpers.createLdm(baseOffset + 1L, archSize, "esp", archSize, "ebp"));
        instructions.add(ReilHelpers.createAdd(baseOffset + 2L, archSize, "esp", archSize, "4", resultSize, addResult));
        instructions.add(ReilHelpers.createAnd(baseOffset + 3L, resultSize, addResult, archSize, truncateMask, archSize, "esp"));
    }
}

