/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.TranslationResultType;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.List;

public class ImulTranslator
implements IInstructionTranslator {
    private TranslationResult generateImul(ITranslationEnvironment environment, long offset, String operand1, String operand2, OperandSize size1, OperandSize size2) {
        long baseOffset;
        long newOffset = baseOffset = offset;
        OperandSize resultSize = TranslationHelpers.getNextSize(size1);
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        Pair<String, String> abs1 = Helpers.generateAbs(environment, newOffset, operand1, size1, instructions);
        newOffset = baseOffset + (long)instructions.size();
        Pair<String, String> abs2 = Helpers.generateAbs(environment, newOffset, operand2, size2, instructions);
        newOffset = baseOffset + (long)instructions.size();
        String lowerHalfMask = String.valueOf(TranslationHelpers.getAllBitsMask(size1));
        String multResult = environment.getNextVariableString();
        String xoredSigns = environment.getNextVariableString();
        String toggleMask = environment.getNextVariableString();
        String decResult = environment.getNextVariableString();
        String realResult = environment.getNextVariableString();
        String maskedLowerHalf = environment.getNextVariableString();
        instructions.add(ReilHelpers.createMul(newOffset, size1, abs1.second(), size2, abs2.second(), resultSize, multResult));
        instructions.add(ReilHelpers.createXor(newOffset + 1L, size1, abs1.first(), size2, abs2.first(), size1, xoredSigns));
        instructions.add(ReilHelpers.createSub(newOffset + 2L, size1, "0", size1, xoredSigns, resultSize, toggleMask));
        instructions.add(ReilHelpers.createSub(newOffset + 3L, resultSize, multResult, size1, xoredSigns, resultSize, decResult));
        instructions.add(ReilHelpers.createXor(newOffset + 4L, resultSize, toggleMask, resultSize, decResult, resultSize, realResult));
        instructions.add(ReilHelpers.createAnd(newOffset + 5L, resultSize, realResult, size1, lowerHalfMask, size1, maskedLowerHalf));
        TranslationResult foo = Helpers.extendSign(environment, newOffset + 6L, maskedLowerHalf, size1, resultSize);
        instructions.addAll(foo.getInstructions());
        newOffset = newOffset + 6L + (long)foo.getInstructions().size();
        String cmpResult = environment.getNextVariableString();
        String resultsEqual = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(newOffset, resultSize, realResult, resultSize, foo.getRegister(), resultSize, cmpResult));
        instructions.add(ReilHelpers.createBisz(newOffset + 1L, resultSize, cmpResult, OperandSize.BYTE, resultsEqual));
        instructions.add(ReilHelpers.createBisz(newOffset + 2L, OperandSize.BYTE, resultsEqual, OperandSize.BYTE, "CF"));
        instructions.add(ReilHelpers.createBisz(newOffset + 3L, OperandSize.BYTE, resultsEqual, OperandSize.BYTE, "OF"));
        instructions.add(ReilHelpers.createUndef(newOffset + 4L, OperandSize.BYTE, "ZF"));
        instructions.add(ReilHelpers.createUndef(newOffset + 5L, OperandSize.BYTE, "AF"));
        instructions.add(ReilHelpers.createUndef(newOffset + 6L, OperandSize.BYTE, "PF"));
        return new TranslationResult(realResult, resultSize, TranslationResultType.REGISTER, null, instructions, offset);
    }

    private void generateImul3(ITranslationEnvironment environment, long offset, OperandSize size1, String register1, OperandSize size2, String register2, OperandSize size3, String register3, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationResult result = this.generateImul(environment, offset, register2, register3, size2, size3);
        instructions.addAll(result.getInstructions());
        String resultRegister = result.getRegister();
        this.writeSingleRegisterMulResult(environment, offset + (long)result.getInstructions().size(), resultRegister, register1, size1, instructions);
    }

    private void translate_1(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        List<? extends IOperandTree> operands = instruction.getOperands();
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        TranslationResult firstResult = Helpers.translateOperand(environment, offset, operands.get(0), true);
        instructions.addAll(firstResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult multResult = this.generateImul(environment, offset, "eax", firstResult.getRegister(), OperandSize.DWORD, firstResult.getSize());
        instructions.addAll(multResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        OperandSize size = Helpers.getOperandSize(operands.get(0));
        instructions.addAll(Helpers.writeMulResult(environment, offset, multResult.getRegister(), size));
    }

    private void translate_2(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        List<? extends IOperandTree> operands = instruction.getOperands();
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        TranslationResult firstResult = Helpers.translateOperand(environment, offset, operands.get(0), true);
        instructions.addAll(firstResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult secondResult = Helpers.translateOperand(environment, offset, operands.get(1), true);
        instructions.addAll(secondResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        OperandSize resultSize = OperandSize.sizeStringToValue(operands.get(0).getRootNode().getValue());
        String resultRegister = operands.get(0).getRootNode().getChildren().get(0).getValue();
        this.generateImul3(environment, offset, resultSize, resultRegister, firstResult.getSize(), firstResult.getRegister(), secondResult.getSize(), secondResult.getRegister(), instructions);
    }

    private void translate_3(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        List<? extends IOperandTree> operands = instruction.getOperands();
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        TranslationResult firstResult = Helpers.translateOperand(environment, offset, operands.get(1), true);
        instructions.addAll(firstResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult secondResult = Helpers.translateOperand(environment, offset, operands.get(2), true);
        instructions.addAll(secondResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult targetResult = Helpers.translateOperand(environment, offset, operands.get(0), true);
        instructions.addAll(targetResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        OperandSize resultSize = OperandSize.sizeStringToValue(operands.get(0).getRootNode().getValue());
        String resultRegister = operands.get(0).getRootNode().getChildren().get(0).getValue();
        this.generateImul3(environment, offset, resultSize, resultRegister, firstResult.getSize(), firstResult.getRegister(), secondResult.getSize(), secondResult.getRegister(), instructions);
    }

    private void writeSingleRegisterMulResult(ITranslationEnvironment environment, long offset, String resultRegister, String register1, OperandSize size1, List<ReilInstruction> instructions) throws InternalTranslationException {
        OperandSize archSize = environment.getArchitectureSize();
        if (size1 == archSize) {
            instructions.add(ReilHelpers.createAnd(offset, OperandSize.QWORD, resultRegister, OperandSize.DWORD, "4294967295", OperandSize.DWORD, register1));
        } else {
            Helpers.moveAndMask(environment, offset, size1, resultRegister, register1, instructions);
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "imul");
        if (instruction.getOperands().size() < 1 || instruction.getOperands().size() > 3) {
            throw new InternalTranslationException("Error: Argument instruction is not a imul instruction (invalid number of operand)");
        }
        List<? extends IOperandTree> operands = instruction.getOperands();
        if (operands.size() == 1) {
            this.translate_1(environment, instruction, instructions);
        } else if (operands.size() == 2) {
            this.translate_2(environment, instruction, instructions);
        } else {
            this.translate_3(environment, instruction, instructions);
        }
    }
}

