/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.ExpressionComparator;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.OperandType;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.TranslationResultType;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Helpers {
    private static ExpressionComparator comparator = new ExpressionComparator();
    public static final String AUXILIARY_FLAG = "AF";
    public static final String CARRY_FLAG = "CF";
    public static final String DIRECTION_FLAG = "DF";
    public static final String INTERRUPT_FLAG = "IF";
    public static final String OVERFLOW_FLAG = "OF";
    public static final String PARITY_FLAG = "PF";
    public static final String SIGN_FLAG = "SF";
    public static final String ZERO_FLAG = "ZF";

    private static TranslationResult extractRegister(ITranslationEnvironment environment, long offset, String subRegister) throws InternalTranslationException {
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        String parentRegister = Helpers.getParentRegister(subRegister);
        OperandSize archSize = environment.getArchitectureSize();
        if (Helpers.isHigher8BitRegister(subRegister)) {
            String maskResult = environment.getNextVariableString();
            String shiftResult = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(offset, archSize, parentRegister, OperandSize.WORD, "65280", OperandSize.WORD, maskResult));
            instructions.add(ReilHelpers.createBsh(offset + 1L, OperandSize.WORD, maskResult, OperandSize.WORD, "-8", OperandSize.BYTE, shiftResult));
            return new TranslationResult(shiftResult, OperandSize.BYTE, TranslationResultType.REGISTER, null, instructions, offset);
        }
        OperandSize subRegisterSize = Helpers.getRegisterSize(subRegister);
        String mask = String.valueOf(TranslationHelpers.getAllBitsMask(subRegisterSize));
        String result = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(offset, archSize, parentRegister, subRegisterSize, mask, subRegisterSize, result));
        return new TranslationResult(result, subRegisterSize, TranslationResultType.REGISTER, null, instructions, offset);
    }

    private static void generateRegisterPush(ITranslationEnvironment environment, long baseOffset, String register2, OperandSize size, List<ReilInstruction> instructions) {
        String pValue;
        long offset = baseOffset;
        if (size == OperandSize.DWORD) {
            pValue = register2;
        } else {
            pValue = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(offset, OperandSize.DWORD, register2, size, "65535", size, pValue));
            ++offset;
        }
        Helpers.generatePush(environment, offset, pValue, size, instructions);
    }

    private static Pair<String, String> generateSignMask(ITranslationEnvironment environment, long offset, String value, OperandSize size, List<ReilInstruction> instructions) {
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(size));
        String shiftValue = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(size));
        String maskedMsb = environment.getNextVariableString();
        String msbInLsb = environment.getNextVariableString();
        String signMask = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(offset, size, value, size, msbMask, size, maskedMsb));
        instructions.add(ReilHelpers.createBsh(offset + 1L, size, maskedMsb, size, shiftValue, size, msbInLsb));
        instructions.add(ReilHelpers.createSub(offset + 2L, size, "0", size, msbInLsb, size, signMask));
        return new Pair<String, String>(msbInLsb, signMask);
    }

    private static long getNegativeMask(String register2) throws InternalTranslationException {
        if (Helpers.isLower8BitRegister(register2)) {
            return 0xFFFFFF00L;
        }
        if (Helpers.isHigher8BitRegister(register2)) {
            return 0xFFFF00FFL;
        }
        if (Helpers.is16BitRegister(register2)) {
            return 0xFFFF0000L;
        }
        throw new InternalTranslationException("Error: Invalid register");
    }

    private static boolean is16BitRegister(String register2) {
        return register2.equals("ax") || register2.equals("bx") || register2.equals("cx") || register2.equals("dx") || register2.equals("si") || register2.equals("di") || register2.equals("sp") || register2.equals("bp") || register2.equals("ip");
    }

    private static boolean isLower8BitRegister(String register2) {
        return register2.equals("al") || register2.equals("bl") || register2.equals("cl") || register2.equals("dl");
    }

    private static boolean isMemoryAccess(String value) {
        return value.equals("[");
    }

    private static boolean isSegment(String value) {
        return value.equals("cs") || value.equals("ds") || value.equals("es") || value.equals("fs") || value.equals("gs") || value.equals("ss");
    }

    private static boolean isSegmentExpression(String value) {
        return value.endsWith(":") && Helpers.isSegment(value.substring(0, value.length() - 1));
    }

    private static List<TranslationResult> translateChildrenOfNode(ITranslationEnvironment environment, IOperandTreeNode expression, OperandSize size, boolean loadOperand, Long baseOffset) throws InternalTranslationException {
        ArrayList<TranslationResult> partialResults = new ArrayList<TranslationResult>();
        List<? extends IOperandTreeNode> children = expression.getChildren();
        Collections.sort(children, comparator);
        for (IOperandTreeNode iOperandTreeNode : children) {
            TranslationResult nextResult = Helpers.loadOperand(environment, baseOffset, iOperandTreeNode, Helpers.isSegmentExpression(expression.getValue()) ? expression : null, size, loadOperand);
            partialResults.add(nextResult);
            baseOffset = baseOffset + (long)nextResult.getInstructions().size();
        }
        return partialResults;
    }

    private static TranslationResult processLeafNode(ITranslationEnvironment environment, long baseOffset, IOperandTreeNode expression, OperandSize size, boolean loadOperand) throws InternalTranslationException {
        String value = expression.getValue();
        OperandType operandType = OperandType.getOperandType(value);
        TranslationResultType nodeType = null;
        switch (operandType) {
            case REGISTER: {
                nodeType = TranslationResultType.REGISTER;
                break;
            }
            case INTEGER_LITERAL: {
                nodeType = TranslationResultType.LITERAL;
                break;
            }
            default: {
                throw new InternalTranslationException("Error: Leaf has invalid type");
            }
        }
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        String nextVariableString = environment.getNextVariableString();
        if (operandType == OperandType.INTEGER_LITERAL || !Helpers.needsExtraction(environment, value)) {
            if (loadOperand) {
                instructions.add(ReilHelpers.createStr(baseOffset, size, value, size, nextVariableString));
                return new TranslationResult(nextVariableString, size, nodeType, null, instructions, baseOffset);
            }
            return new TranslationResult(value, size, nodeType, null, instructions, baseOffset);
        }
        return Helpers.extractRegister(environment, baseOffset, value);
    }

    private static TranslationResult processSimpleMemoryAccess(ITranslationEnvironment environment, IOperandTreeNode segmentOverride, OperandSize size, boolean loadOperand, TranslationResult intermediateResult) {
        TranslationResultType childType = intermediateResult.getType();
        if (childType == TranslationResultType.LITERAL || childType == TranslationResultType.REGISTER) {
            return Helpers.processSimpleMemoryAccessLiteralOrRegisterLoad(environment, segmentOverride, size, loadOperand, intermediateResult);
        }
        return Helpers.processSimpleMemoryAccessFromCompoundAddress(environment, segmentOverride, size, loadOperand, intermediateResult);
    }

    private static TranslationResult processSimpleMemoryAccessFromCompoundAddress(ITranslationEnvironment environment, IOperandTreeNode segmentOverride, OperandSize size, boolean loadOperand, TranslationResult intermediateResult) {
        OperandSize archSize = environment.getArchitectureSize();
        String truncationMask = String.valueOf(TranslationHelpers.getAllBitsMask(archSize));
        String childResult = intermediateResult.getRegister();
        if (segmentOverride != null) {
            String pseudoRegister = Helpers.getSegmentOverridePseudoRegister(segmentOverride);
            String nextVariableString = environment.getNextVariableString();
            intermediateResult.addInstruction(ReilHelpers.createAdd(0L, archSize, childResult, archSize, pseudoRegister, archSize, nextVariableString));
            childResult = nextVariableString;
        }
        String truncatedAddress = environment.getNextVariableString();
        intermediateResult.addInstruction(ReilHelpers.createAnd(0L, archSize, childResult, archSize, truncationMask, archSize, truncatedAddress));
        if (loadOperand) {
            String loadedValue = environment.getNextVariableString();
            intermediateResult.addInstruction(ReilHelpers.createLdm(0L, archSize, truncatedAddress, size, loadedValue));
            intermediateResult.updateResult(loadedValue, size, truncatedAddress, TranslationResultType.MEMORY_ACCESS);
        } else {
            intermediateResult.updateResult(truncatedAddress, size, "", TranslationResultType.MEMORY_ACCESS);
        }
        return intermediateResult;
    }

    private static String getSegmentOverridePseudoRegister(IOperandTreeNode segmentOverride) {
        String value = segmentOverride.getValue();
        return String.valueOf(value.substring(0, value.length() - 1)).concat("base");
    }

    private static TranslationResult processSimpleMemoryAccessLiteralOrRegisterLoad(ITranslationEnvironment environment, IOperandTreeNode segmentOverride, OperandSize size, boolean loadOperand, TranslationResult intermediateResult) {
        OperandSize archSize = environment.getArchitectureSize();
        String childResult = intermediateResult.getRegister();
        String loadTarget = environment.getNextVariableString();
        if (segmentOverride != null) {
            String pseudoRegister = Helpers.getSegmentOverridePseudoRegister(segmentOverride);
            String nextVariableString = environment.getNextVariableString();
            intermediateResult.addInstruction(ReilHelpers.createAdd(0L, archSize, childResult, archSize, pseudoRegister, archSize, nextVariableString));
            if (loadOperand) {
                intermediateResult.addInstruction(ReilHelpers.createLdm(0L, archSize, nextVariableString, size, loadTarget));
                intermediateResult.updateResult(loadTarget, size, nextVariableString, TranslationResultType.MEMORY_ACCESS);
            } else {
                intermediateResult.updateResult(nextVariableString, size, nextVariableString, TranslationResultType.MEMORY_ACCESS);
            }
        } else if (loadOperand) {
            intermediateResult.addInstruction(ReilHelpers.createLdm(0L, archSize, childResult, size, loadTarget));
            intermediateResult.updateResult(loadTarget, size, childResult, TranslationResultType.MEMORY_ACCESS);
        } else {
            intermediateResult.updateResult(intermediateResult.getRegister(), size, childResult, TranslationResultType.MEMORY_ACCESS);
        }
        return intermediateResult;
    }

    private static TranslationResult loadOperand(ITranslationEnvironment environment, Long baseOffset, IOperandTreeNode expression, IOperandTreeNode segmentOverride, OperandSize size, boolean loadOperand) throws InternalTranslationException {
        String currentNodeValue = expression.getValue();
        int numberOfChildren = expression.getChildren().size();
        if (TranslationHelpers.isSizeExpression(expression)) {
            size = OperandSize.sizeStringToValue(currentNodeValue);
        }
        Long newBaseOffset = (long)baseOffset;
        OperandSize childrenSize = Helpers.isMemoryAccess(currentNodeValue) ? environment.getArchitectureSize() : size;
        List<TranslationResult> partialResults = Helpers.translateChildrenOfNode(environment, expression, childrenSize, loadOperand, newBaseOffset);
        switch (numberOfChildren) {
            case 0: {
                return Helpers.processLeafNode(environment, newBaseOffset, expression, size, loadOperand);
            }
            case 1: {
                if (OperandSize.isSizeString(currentNodeValue)) {
                    return partialResults.get(0);
                }
                if (Helpers.isSegmentExpression(currentNodeValue)) {
                    return partialResults.get(0);
                }
                if (Helpers.isMemoryAccess(currentNodeValue)) {
                    return Helpers.processSimpleMemoryAccess(environment, segmentOverride, size, loadOperand, partialResults.get(0));
                }
                throw new InternalTranslationException("Error: Unknown node type with one child during address operand translation");
            }
        }
        return Helpers.processInOperandArithmetic(partialResults, environment, newBaseOffset, expression);
    }

    private static void addPlusOrTimesInOperandArithmetic(ITranslationEnvironment environment, String value, String source1, String source2, String destination, TranslationResult finalResult) {
        OperandSize archSize = environment.getArchitectureSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(archSize);
        if (value.equals("+")) {
            finalResult.addInstruction(ReilHelpers.createAdd(0L, archSize, source1, archSize, source2, resultSize, destination));
        } else if (value.equals("*")) {
            finalResult.addInstruction(ReilHelpers.createMul(0L, archSize, source1, archSize, source2, resultSize, destination));
        }
    }

    private static TranslationResult processInOperandArithmetic(List<TranslationResult> partialResults, ITranslationEnvironment environment, long baseOffset, IOperandTreeNode expression) throws InternalTranslationException {
        String value = expression.getValue();
        OperandSize archSize = environment.getArchitectureSize();
        OperandSize nextSize = TranslationHelpers.getNextSize(archSize);
        TranslationResult finalResult = new TranslationResult("NEEDS_REPLACEMENT", archSize, TranslationResultType.REGISTER, "", new ArrayList<ReilInstruction>(), baseOffset);
        if (value.equals("+") || value.equals("*")) {
            ArrayList<ReilInstruction> allInstructions = new ArrayList<ReilInstruction>();
            for (TranslationResult result : partialResults) {
                allInstructions.addAll(result.getInstructions());
            }
            finalResult.updateBaseAndReil(baseOffset, allInstructions);
            String source1 = partialResults.get(0).getRegister();
            String source2 = partialResults.get(1).getRegister();
            String currentTemporary = environment.getNextVariableString();
            for (int index = 2; index <= partialResults.size(); ++index) {
                Helpers.addPlusOrTimesInOperandArithmetic(environment, value, source1, source2, currentTemporary, finalResult);
                if (index >= partialResults.size()) continue;
                source1 = partialResults.get(index).getRegister();
                source2 = currentTemporary;
            }
            String truncationMask = String.valueOf(TranslationHelpers.getAllBitsMask(archSize));
            finalResult.addInstruction(ReilHelpers.createAnd(0L, nextSize, currentTemporary, nextSize, truncationMask, archSize, currentTemporary));
            finalResult.updateResult(currentTemporary, archSize, "", TranslationResultType.REGISTER);
        } else if (value.equals(":")) {
            throw new InternalTranslationException("Error: Don't know how to deal with 1234:ABCD1234 (segment:address) operands.");
        }
        return finalResult;
    }

    private static boolean needsExtraction(ITranslationEnvironment environment, String registerName) throws InternalTranslationException {
        return Helpers.getRegisterSize(registerName) != environment.getArchitectureSize() && !Helpers.isSegment(registerName);
    }

    public static TranslationResult extendSign(ITranslationEnvironment environment, long offset, String value, OperandSize size, OperandSize extendedSize) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(value, "Error: Argument value can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(extendedSize, "Error: Argument extendedSize can't be null");
        Preconditions.checkArgument(size.getByteSize() < extendedSize.getByteSize(), "Error: Argument size must be smaller than argument extendedSize");
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(size));
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(extendedSize));
        String toggledMsb = environment.getNextVariableString();
        String extendedValue = environment.getNextVariableString();
        String truncatedValue = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(offset, size, value, size, msbMask, size, toggledMsb));
        instructions.add(ReilHelpers.createSub(offset + 1L, size, toggledMsb, size, msbMask, extendedSize, extendedValue));
        instructions.add(ReilHelpers.createAnd(offset + 2L, extendedSize, extendedValue, extendedSize, truncateMask, extendedSize, truncatedValue));
        return new TranslationResult(truncatedValue, extendedSize, TranslationResultType.REGISTER, null, instructions, offset);
    }

    public static Pair<String, String> generateAbs(ITranslationEnvironment environment, long baseOffset, String value, OperandSize size, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(value, "Error: Argument value can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        int oldInstructionsSize = instructions.size();
        Pair<String, String> signMask = Helpers.generateSignMask(environment, baseOffset, value, size, instructions);
        long offset = baseOffset + (long)instructions.size() - (long)oldInstructionsSize;
        String toggledSign = environment.getNextVariableString();
        String absValue = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(offset, size, value, size, signMask.second(), size, toggledSign));
        instructions.add(ReilHelpers.createSub(offset + 1L, size, toggledSign, size, signMask.second(), size, absValue));
        return new Pair<String, String>(signMask.first(), absValue);
    }

    public static String generateAnd(ITranslationEnvironment environment, long offset, OperandSize size, String operand1, String operand2, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(operand1, "Error: Argument operand1 can't be null");
        Preconditions.checkNotNull(operand2, "Error: Argument operand2 can't be null");
        String result = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(offset, size, operand1, size, operand2, size, result));
        Helpers.generateBinaryOperationFlags(environment, offset + 1L, result, size, instructions);
        return result;
    }

    public static void generateBinaryOperationFlags(ITranslationEnvironment environment, long nextOffset, String result, OperandSize resultSize, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(result, "Error: Argument result can't be null");
        Preconditions.checkNotNull(resultSize, "Error: Argument resultSize can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        long baseOffset = nextOffset - (long)instructions.size();
        long offset = nextOffset;
        Helpers.generateSignFlagCode(environment, offset, result, resultSize, instructions);
        offset = baseOffset + (long)instructions.size() - 1L;
        instructions.add(ReilHelpers.createBisz(offset + 1L, resultSize, result, OperandSize.BYTE, ZERO_FLAG));
        instructions.add(ReilHelpers.createStr(offset + 2L, OperandSize.BYTE, "0", OperandSize.BYTE, CARRY_FLAG));
        instructions.add(ReilHelpers.createStr(offset + 3L, OperandSize.BYTE, "0", OperandSize.BYTE, OVERFLOW_FLAG));
    }

    public static void generateLoadFromStack(ITranslationEnvironment environment, long baseOffset, OperandSize size, String target, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(target, "Error: Argument target can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        long offset = baseOffset;
        OperandSize archSize = environment.getArchitectureSize();
        if (size == archSize) {
            Helpers.generatePop(environment, offset, size, target, instructions);
        } else {
            String loadedReg = Helpers.generatePop(environment, offset, size, null, instructions);
            String maskedReg = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(offset += (long)instructions.size(), size, target, size, "4294901760", size, maskedReg));
            instructions.add(ReilHelpers.createOr(offset + 1L, size, loadedReg, size, maskedReg, size, target));
        }
    }

    public static void generateMov(ITranslationEnvironment environment, long baseOffset, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        long reilOffset = baseOffset;
        List<? extends IOperandTree> operands = instruction.getOperands();
        TranslationResult loadSource = Helpers.translateOperand(environment, reilOffset, operands.get(1), true);
        instructions.addAll(loadSource.getInstructions());
        reilOffset = baseOffset + (long)instructions.size();
        TranslationResult loadDest = Helpers.translateOperand(environment, reilOffset, operands.get(0), false);
        instructions.addAll(loadDest.getInstructions());
        reilOffset = baseOffset + (long)instructions.size();
        Helpers.writeBack(environment, reilOffset, operands.get(0), loadSource.getRegister(), loadDest.getSize(), loadDest.getAddress(), loadDest.getType(), instructions);
    }

    public static String generatePop(ITranslationEnvironment environment, long offset, OperandSize size, String target, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        OperandSize archSize = environment.getArchitectureSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(archSize);
        String loadedValue = target == null ? environment.getNextVariableString() : target;
        instructions.add(ReilHelpers.createLdm(offset, archSize, "esp", size, loadedValue));
        String tempEsp = environment.getNextVariableString();
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(archSize));
        String stackValue = String.valueOf(size.getByteSize());
        instructions.add(ReilHelpers.createAdd(offset + 1L, archSize, "esp", archSize, stackValue, resultSize, tempEsp));
        instructions.add(ReilHelpers.createAnd(offset + 2L, resultSize, tempEsp, archSize, truncateMask, archSize, "esp"));
        return loadedValue;
    }

    public static void generatePush(ITranslationEnvironment environment, long offset, String value, OperandSize size, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(value, "Error: Argument value can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        OperandSize archSize = environment.getArchitectureSize();
        OperandSize nextSize = TranslationHelpers.getNextSize(archSize);
        String addResult = environment.getNextVariableString();
        String mask = String.valueOf(TranslationHelpers.getAllBitsMask(archSize));
        String subtractionValue = String.valueOf(size.getByteSize());
        instructions.add(ReilHelpers.createSub(offset, archSize, "esp", archSize, subtractionValue, nextSize, addResult));
        instructions.add(ReilHelpers.createAnd(offset + 1L, nextSize, addResult, archSize, mask, archSize, "esp"));
        instructions.add(ReilHelpers.createStm(offset + 2L, size, value, archSize, "esp"));
    }

    public static void generatePushAllRegisters(ITranslationEnvironment environment, long baseOffset, OperandSize size, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        Preconditions.checkArgument(size == OperandSize.WORD || size == OperandSize.DWORD, "Error: Invalid size argument");
        long offset = baseOffset;
        OperandSize archSize = environment.getArchitectureSize();
        String tempEsp = environment.getNextVariableString();
        instructions.add(ReilHelpers.createStr(offset, archSize, "esp", archSize, tempEsp));
        Helpers.generateRegisterPush(environment, offset + 1L, "eax", size, instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateRegisterPush(environment, offset, "ebx", size, instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateRegisterPush(environment, offset, "ecx", size, instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateRegisterPush(environment, offset, "edx", size, instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateRegisterPush(environment, offset, tempEsp, size, instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateRegisterPush(environment, offset, "ebp", size, instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateRegisterPush(environment, offset, "esi", size, instructions);
        offset = baseOffset + (long)instructions.size();
        Helpers.generateRegisterPush(environment, offset, "edi", size, instructions);
        offset = baseOffset + (long)instructions.size();
    }

    public static void generateSignFlagCode(ITranslationEnvironment environment, long offset, String value, OperandSize valueSize, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(value, "Error: Argument value can't be null");
        Preconditions.checkNotNull(valueSize, "Error: Argument valueSize can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        String maskValue = environment.getNextVariableString();
        String mask = String.valueOf(TranslationHelpers.getMsbMask(valueSize));
        String shiftValue = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(valueSize));
        instructions.add(ReilHelpers.createAnd(offset, valueSize, value, valueSize, mask, valueSize, maskValue));
        instructions.add(ReilHelpers.createBsh(offset + 1L, valueSize, maskValue, valueSize, shiftValue, OperandSize.BYTE, SIGN_FLAG));
    }

    public static String generateSub(ITranslationEnvironment environment, long offset, OperandSize size, String operand1, String operand2, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(operand1, "Error: Argument operand1 can't be null");
        Preconditions.checkNotNull(operand2, "Error: Argument operand2 can't be null");
        OperandSize resultSize = TranslationHelpers.getNextSize(size);
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(size));
        String shiftMsbLsb = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(size));
        String carryMask = String.valueOf(Helpers.getCarryMask(size));
        String shiftCarryLsb = String.valueOf(-size.getBitSize());
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(size));
        String maskedOp1 = environment.getNextVariableString();
        String maskedOp2 = environment.getNextVariableString();
        String subResult = environment.getNextVariableString();
        String msbResult = environment.getNextVariableString();
        String msbSameBefore = environment.getNextVariableString();
        String msbHasChanged = environment.getNextVariableString();
        String tempOf = environment.getNextVariableString();
        String tempCf = environment.getNextVariableString();
        String truncatedResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(offset, size, operand1, size, msbMask, size, maskedOp1));
        instructions.add(ReilHelpers.createAnd(offset + 1L, size, operand2, size, msbMask, size, maskedOp2));
        instructions.add(ReilHelpers.createSub(offset + 2L, size, operand1, size, operand2, resultSize, subResult));
        instructions.add(ReilHelpers.createAnd(offset + 3L, resultSize, subResult, resultSize, msbMask, size, msbResult));
        instructions.add(ReilHelpers.createBsh(offset + 4L, size, msbResult, size, shiftMsbLsb, OperandSize.BYTE, SIGN_FLAG));
        instructions.add(ReilHelpers.createXor(offset + 5L, size, maskedOp1, size, maskedOp2, size, msbSameBefore));
        instructions.add(ReilHelpers.createXor(offset + 6L, size, maskedOp1, size, msbResult, size, msbHasChanged));
        instructions.add(ReilHelpers.createAnd(offset + 7L, size, msbSameBefore, size, msbHasChanged, size, tempOf));
        instructions.add(ReilHelpers.createBsh(offset + 8L, size, tempOf, size, shiftMsbLsb, OperandSize.BYTE, OVERFLOW_FLAG));
        instructions.add(ReilHelpers.createAnd(offset + 9L, resultSize, subResult, resultSize, carryMask, resultSize, tempCf));
        instructions.add(ReilHelpers.createBsh(offset + 10L, resultSize, tempCf, resultSize, shiftCarryLsb, OperandSize.BYTE, CARRY_FLAG));
        instructions.add(ReilHelpers.createAnd(offset + 11L, resultSize, subResult, resultSize, truncateMask, size, truncatedResult));
        instructions.add(ReilHelpers.createBisz(offset + 12L, size, truncatedResult, OperandSize.BYTE, ZERO_FLAG));
        return truncatedResult;
    }

    public static long getCarryMask(OperandSize size) {
        switch (size) {
            case BYTE: {
                return 256L;
            }
            case WORD: {
                return 65536L;
            }
            case DWORD: {
                return 0x100000000L;
            }
            case ADDRESS: {
                break;
            }
            case EMPTY: {
                break;
            }
            case OWORD: {
                break;
            }
            case QWORD: {
                break;
            }
        }
        throw new IllegalArgumentException("Error: Invalid argument size");
    }

    public static String getLeafValue(IOperandTreeNode expression) throws IllegalArgumentException, InternalTranslationException {
        Preconditions.checkNotNull(expression, "Error: Argument expression can't be null");
        List<? extends IOperandTreeNode> children = expression.getChildren();
        if (children.size() == 0) {
            return expression.getValue();
        }
        if (children.size() == 1) {
            return Helpers.getLeafValue(children.get(0));
        }
        throw new InternalTranslationException("Error: Expression tree has invalid structure");
    }

    public static OperandSize getOperandSize(IOperandTree operand) {
        Preconditions.checkNotNull(operand, "Error: Argument operand can't be null");
        String sizeString = operand.getRootNode().getValue();
        return OperandSize.sizeStringToValue(sizeString);
    }

    public static String getParentRegister(String subRegister) throws InternalTranslationException {
        Preconditions.checkNotNull(subRegister, "Error: Argument subRegister can't be null");
        if (subRegister.equals("al") || subRegister.equals("ah") || subRegister.equals("ax")) {
            return "eax";
        }
        if (subRegister.equals("bl") || subRegister.equals("bh") || subRegister.equals("bx")) {
            return "ebx";
        }
        if (subRegister.equals("cl") || subRegister.equals("ch") || subRegister.equals("cx")) {
            return "ecx";
        }
        if (subRegister.equals("dl") || subRegister.equals("dh") || subRegister.equals("dx")) {
            return "edx";
        }
        if (subRegister.equals("si")) {
            return "esi";
        }
        if (subRegister.equals("di")) {
            return "edi";
        }
        if (subRegister.equals("sp")) {
            return "esp";
        }
        if (subRegister.equals("bp")) {
            return "ebp";
        }
        if (subRegister.equals("ip")) {
            return "eip";
        }
        throw new InternalTranslationException(String.format("Error: Invalid subRegister %s", subRegister));
    }

    public static OperandSize getRegisterSize(String register2) throws InternalTranslationException {
        if (register2.equals("al") || register2.equals("ah") || register2.equals("bl") || register2.equals("bh") || register2.equals("cl") || register2.equals("ch") || register2.equals("dl") || register2.equals("dh")) {
            return OperandSize.BYTE;
        }
        if (register2.equals("ax") || register2.equals("bx") || register2.equals("cx") || register2.equals("dx") || register2.equals("si") || register2.equals("di") || register2.equals("sp") || register2.equals("bp") || register2.equals("ip") || Helpers.isSegment(register2)) {
            return OperandSize.WORD;
        }
        if (register2.equals("eax") || register2.equals("ebx") || register2.equals("ecx") || register2.equals("edx") || register2.equals("esi") || register2.equals("edi") || register2.equals("esp") || register2.equals("ebp")) {
            return OperandSize.DWORD;
        }
        throw new InternalTranslationException(String.format("Error: Invalid register name %s", register2));
    }

    public static boolean isHigher8BitRegister(String register2) {
        return register2.equals("ah") || register2.equals("bh") || register2.equals("ch") || register2.equals("dh");
    }

    public static TranslationResult loadFirstDivOperand(ITranslationEnvironment environment, long offset, OperandSize size) {
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        OperandSize archSize = environment.getArchitectureSize();
        if (size == OperandSize.BYTE) {
            String dividend = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(offset, archSize, "eax", OperandSize.BYTE, "255", OperandSize.BYTE, dividend));
            return new TranslationResult(dividend, OperandSize.BYTE, TranslationResultType.REGISTER, null, instructions, offset);
        }
        if (size == OperandSize.WORD) {
            String extractedAx = environment.getNextVariableString();
            String extractedDx = environment.getNextVariableString();
            String shiftedDx = environment.getNextVariableString();
            String dividend = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(offset, archSize, "eax", OperandSize.WORD, "65535", size, extractedAx));
            instructions.add(ReilHelpers.createAnd(offset + 1L, archSize, "edx", OperandSize.WORD, "65535", size, extractedDx));
            instructions.add(ReilHelpers.createBsh(offset + 2L, OperandSize.WORD, extractedDx, OperandSize.WORD, "16", OperandSize.DWORD, shiftedDx));
            instructions.add(ReilHelpers.createOr(offset + 3L, OperandSize.WORD, extractedAx, OperandSize.DWORD, shiftedDx, OperandSize.DWORD, dividend));
            return new TranslationResult(dividend, OperandSize.DWORD, TranslationResultType.REGISTER, null, instructions, offset);
        }
        if (size == OperandSize.DWORD) {
            String shiftedEdx = environment.getNextVariableString();
            String dividend = environment.getNextVariableString();
            instructions.add(ReilHelpers.createBsh(offset, OperandSize.DWORD, "edx", OperandSize.DWORD, "32", OperandSize.QWORD, shiftedEdx));
            instructions.add(ReilHelpers.createOr(offset + 1L, OperandSize.DWORD, "eax", OperandSize.QWORD, shiftedEdx, OperandSize.QWORD, dividend));
            return new TranslationResult(dividend, OperandSize.QWORD, TranslationResultType.REGISTER, null, instructions, offset);
        }
        assert (false);
        return null;
    }

    public static void moveAndMask(ITranslationEnvironment environment, long offset, OperandSize valueSize, String value, String subRegister, List<ReilInstruction> instructions) throws IllegalArgumentException, InternalTranslationException, IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(value, "Error: Argument value can't be null");
        Preconditions.checkNotNull(subRegister, "Error: Argument subRegister can't be null");
        Preconditions.checkNotNull(valueSize, "Error: Argument valueSize can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        String parentRegister = Helpers.getParentRegister(subRegister);
        OperandSize registerSize = Helpers.getRegisterSize(subRegister);
        OperandSize parentRegisterSize = Helpers.getRegisterSize(parentRegister);
        OperandSize archSize = environment.getArchitectureSize();
        if (registerSize.getByteSize() >= archSize.getByteSize()) {
            throw new InternalTranslationException("Error: Register is not a subregister");
        }
        if (valueSize.getByteSize() >= archSize.getByteSize()) {
            throw new InternalTranslationException("Error: Value doesn't fit into a subregister");
        }
        if (valueSize.getByteSize() >= parentRegisterSize.getByteSize()) {
            throw new InternalTranslationException("Error: Value doesn't fit into a parent register");
        }
        String mask = String.valueOf(Helpers.getNegativeMask(subRegister));
        if (Helpers.isHigher8BitRegister(subRegister)) {
            String shiftedValue = environment.getNextVariableString();
            String maskedValue = environment.getNextVariableString();
            instructions.add(ReilHelpers.createBsh(offset, valueSize, value, valueSize, "8", archSize, shiftedValue));
            instructions.add(ReilHelpers.createAnd(offset + 1L, archSize, parentRegister, archSize, mask, archSize, maskedValue));
            instructions.add(ReilHelpers.createOr(offset + 2L, archSize, shiftedValue, archSize, maskedValue, archSize, parentRegister));
        } else {
            String maskedValue = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(offset, archSize, parentRegister, archSize, mask, archSize, maskedValue));
            instructions.add(ReilHelpers.createOr(offset + 1L, valueSize, value, archSize, maskedValue, archSize, parentRegister));
        }
    }

    public static String shiftFlagsIntoValue(ITranslationEnvironment environment, long offset, OperandSize size, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        String startValue = environment.getNextVariableString();
        String afterCf = environment.getNextVariableString();
        String shiftedPf = environment.getNextVariableString();
        String afterPf = environment.getNextVariableString();
        String shiftedAf = environment.getNextVariableString();
        String afterAf = environment.getNextVariableString();
        String shiftedZf = environment.getNextVariableString();
        String afterZf = environment.getNextVariableString();
        String shiftedSf = environment.getNextVariableString();
        String afterSf = environment.getNextVariableString();
        String shiftedOf = environment.getNextVariableString();
        String afterOf = environment.getNextVariableString();
        instructions.add(ReilHelpers.createStr(offset, size, "2", size, startValue));
        instructions.add(ReilHelpers.createOr(offset + 1L, size, startValue, OperandSize.BYTE, CARRY_FLAG, size, afterCf));
        instructions.add(ReilHelpers.createBsh(offset + 2L, OperandSize.BYTE, PARITY_FLAG, OperandSize.BYTE, "2", size, shiftedPf));
        instructions.add(ReilHelpers.createOr(offset + 3L, size, afterCf, size, shiftedPf, size, afterPf));
        instructions.add(ReilHelpers.createBsh(offset + 4L, OperandSize.BYTE, AUXILIARY_FLAG, OperandSize.BYTE, "4", size, shiftedAf));
        instructions.add(ReilHelpers.createOr(offset + 5L, size, afterPf, size, shiftedAf, size, afterAf));
        instructions.add(ReilHelpers.createBsh(offset + 6L, OperandSize.BYTE, ZERO_FLAG, OperandSize.BYTE, "6", size, shiftedZf));
        instructions.add(ReilHelpers.createOr(offset + 7L, size, afterAf, size, shiftedZf, size, afterZf));
        instructions.add(ReilHelpers.createBsh(offset + 8L, OperandSize.BYTE, SIGN_FLAG, OperandSize.BYTE, "7", size, shiftedSf));
        instructions.add(ReilHelpers.createOr(offset + 9L, size, afterZf, size, shiftedSf, size, afterSf));
        instructions.add(ReilHelpers.createBsh(offset + 10L, OperandSize.BYTE, OVERFLOW_FLAG, OperandSize.BYTE, "11", size, shiftedOf));
        instructions.add(ReilHelpers.createOr(offset + 11L, size, afterSf, size, shiftedOf, size, afterOf));
        return afterOf;
    }

    public static void shiftValueIntoFlags(ITranslationEnvironment environment, long offset, String value, OperandSize size, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(value, "Error: Argument value can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        String pfInLsb = environment.getNextVariableString();
        String afInLsb = environment.getNextVariableString();
        String zfInLsb = environment.getNextVariableString();
        String sfInLsb = environment.getNextVariableString();
        String ofInLsb = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(offset, size, value, size, "1", OperandSize.BYTE, CARRY_FLAG));
        instructions.add(ReilHelpers.createBsh(offset + 1L, size, value, size, "-2", size, pfInLsb));
        instructions.add(ReilHelpers.createAnd(offset + 2L, size, pfInLsb, size, "1", OperandSize.BYTE, PARITY_FLAG));
        instructions.add(ReilHelpers.createBsh(offset + 3L, size, value, size, "-4", size, afInLsb));
        instructions.add(ReilHelpers.createAnd(offset + 4L, size, afInLsb, size, "1", OperandSize.BYTE, AUXILIARY_FLAG));
        instructions.add(ReilHelpers.createBsh(offset + 5L, size, value, size, "-6", size, zfInLsb));
        instructions.add(ReilHelpers.createAnd(offset + 6L, size, zfInLsb, size, "1", OperandSize.BYTE, ZERO_FLAG));
        instructions.add(ReilHelpers.createBsh(offset + 7L, size, value, size, "-7", size, sfInLsb));
        instructions.add(ReilHelpers.createAnd(offset + 8L, size, sfInLsb, size, "1", OperandSize.BYTE, SIGN_FLAG));
        instructions.add(ReilHelpers.createBsh(offset + 9L, size, value, size, "-11", size, ofInLsb));
        instructions.add(ReilHelpers.createAnd(offset + 10L, size, ofInLsb, size, "1", OperandSize.BYTE, OVERFLOW_FLAG));
    }

    public static TranslationResult translateOperand(ITranslationEnvironment environment, long offset, IOperandTree operand, boolean loadOperand) throws InternalTranslationException, IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(operand, "Error: Argument operand can't be null");
        return Helpers.loadOperand(environment, offset, operand.getRootNode(), null, OperandSize.sizeStringToValue(operand.getRootNode().getValue()), loadOperand);
    }

    public static void writeBack(ITranslationEnvironment environment, long offset, IOperandTree targetOperand, String sourceValue, OperandSize size, String address, TranslationResultType targetType, List<ReilInstruction> instructions) throws IllegalArgumentException, InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(targetOperand, "Error: Argument targetOperand can't be null");
        Preconditions.checkNotNull(sourceValue, "Error: Argument sourceValue can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(targetType, "Error: Argument targetType can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        OperandSize archSize = environment.getArchitectureSize();
        if (targetType == TranslationResultType.REGISTER) {
            if (address != null) {
                throw new InternalTranslationException("Error: Invalid combination of parameters");
            }
            String target = Helpers.getLeafValue(targetOperand.getRootNode());
            if (size == archSize || Helpers.isSegment(target)) {
                instructions.add(ReilHelpers.createStr(offset, size, sourceValue, size, target));
            } else {
                Helpers.moveAndMask(environment, offset, size, sourceValue, target, instructions);
            }
        } else if (targetType == TranslationResultType.MEMORY_ACCESS) {
            instructions.add(ReilHelpers.createStm(offset, size, sourceValue, archSize, address));
        } else {
            throw new InternalTranslationException("Error: Invalid target type");
        }
    }

    public static void writeParityFlag(ITranslationEnvironment environment, long offset, OperandSize resultSize, String result, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(resultSize, "Error: Argument resultSize can't be null");
        Preconditions.checkNotNull(result, "Error: Argument result can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        String tempReg = environment.getNextVariableString();
        instructions.add(ReilHelpers.createStr(offset, resultSize, result, resultSize, tempReg));
        instructions.add(ReilHelpers.createBsh(offset + 1L, resultSize, tempReg, OperandSize.BYTE, "-4", resultSize, PARITY_FLAG));
        instructions.add(ReilHelpers.createXor(offset + 2L, resultSize, tempReg, resultSize, PARITY_FLAG, resultSize, PARITY_FLAG));
        instructions.add(ReilHelpers.createAnd(offset + 3L, resultSize, PARITY_FLAG, resultSize, String.valueOf(255L), OperandSize.WORD, PARITY_FLAG));
        instructions.add(ReilHelpers.createBsh(offset + 4L, OperandSize.WORD, String.valueOf(38505L), OperandSize.WORD, PARITY_FLAG, OperandSize.WORD, PARITY_FLAG));
        instructions.add(ReilHelpers.createAnd(offset + 5L, OperandSize.WORD, PARITY_FLAG, OperandSize.WORD, String.valueOf(32768L), OperandSize.WORD, PARITY_FLAG));
        instructions.add(ReilHelpers.createBsh(offset + 6L, OperandSize.WORD, PARITY_FLAG, OperandSize.BYTE, "-15", OperandSize.BYTE, PARITY_FLAG));
    }

    public static ArrayList<ReilInstruction> writeDivResult(ITranslationEnvironment environment, long offset, String realDivResult, String realModResult, OperandSize size) {
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        OperandSize archSize = environment.getArchitectureSize();
        if (size == OperandSize.BYTE) {
            String maskedEax = environment.getNextVariableString();
            String partEax = environment.getNextVariableString();
            String shiftedModResult = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(offset, archSize, "eax", archSize, "4294901760", archSize, maskedEax));
            instructions.add(ReilHelpers.createOr(offset + 1L, archSize, maskedEax, size, realDivResult, archSize, partEax));
            instructions.add(ReilHelpers.createBsh(offset + 2L, size, realModResult, size, "8", archSize, shiftedModResult));
            instructions.add(ReilHelpers.createOr(offset + 3L, archSize, partEax, archSize, shiftedModResult, archSize, "eax"));
            return instructions;
        }
        if (size == OperandSize.WORD) {
            String maskedEax = environment.getNextVariableString();
            String maskedEdx = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(offset, archSize, "eax", archSize, "4294901760", archSize, maskedEax));
            instructions.add(ReilHelpers.createOr(offset + 1L, archSize, maskedEax, size, realDivResult, archSize, "eax"));
            instructions.add(ReilHelpers.createAnd(offset + 2L, archSize, "edx", archSize, "4294901760", archSize, maskedEdx));
            instructions.add(ReilHelpers.createOr(offset + 3L, archSize, maskedEdx, size, realDivResult, archSize, "edx"));
            return instructions;
        }
        if (size == OperandSize.DWORD) {
            instructions.add(ReilHelpers.createStr(offset, size, realDivResult, size, "eax"));
            instructions.add(ReilHelpers.createStr(offset + 1L, size, realModResult, size, "edx"));
            return instructions;
        }
        assert (false);
        return null;
    }

    public static ArrayList<ReilInstruction> writeMulResult(ITranslationEnvironment environment, long offset, String result, OperandSize size) {
        ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
        OperandSize archSize = environment.getArchitectureSize();
        if (size == OperandSize.BYTE) {
            String maskedEax = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(offset, archSize, "eax", archSize, "4294901760", archSize, maskedEax));
            instructions.add(ReilHelpers.createOr(offset + 1L, OperandSize.WORD, result, archSize, maskedEax, archSize, "eax"));
            return instructions;
        }
        if (size == OperandSize.WORD) {
            String maskResNeg = "4294901760";
            String maskedEax = environment.getNextVariableString();
            String maskedResult = environment.getNextVariableString();
            String maskedEdx = environment.getNextVariableString();
            String shiftedResult = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(offset, OperandSize.DWORD, "eax", OperandSize.DWORD, "4294901760", OperandSize.DWORD, maskedEax));
            instructions.add(ReilHelpers.createAnd(offset + 1L, OperandSize.DWORD, result, OperandSize.DWORD, "65535", OperandSize.DWORD, maskedResult));
            instructions.add(ReilHelpers.createOr(offset + 2L, OperandSize.DWORD, maskedEax, OperandSize.DWORD, maskedResult, OperandSize.DWORD, "eax"));
            instructions.add(ReilHelpers.createAnd(offset + 3L, OperandSize.DWORD, "edx", OperandSize.DWORD, "4294901760", OperandSize.DWORD, maskedEdx));
            instructions.add(ReilHelpers.createBsh(offset + 4L, OperandSize.DWORD, result, OperandSize.DWORD, "-16", OperandSize.DWORD, shiftedResult));
            instructions.add(ReilHelpers.createOr(offset + 5L, OperandSize.DWORD, maskedEdx, OperandSize.DWORD, shiftedResult, OperandSize.DWORD, "edx"));
            return instructions;
        }
        if (size == OperandSize.DWORD) {
            instructions.add(ReilHelpers.createAnd(offset, OperandSize.QWORD, result, OperandSize.DWORD, "4294967295", OperandSize.DWORD, "eax"));
            instructions.add(ReilHelpers.createBsh(offset + 1L, OperandSize.QWORD, result, OperandSize.QWORD, "-32", OperandSize.DWORD, "edx"));
            return instructions;
        }
        assert (false);
        return instructions;
    }
}

