/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.x86.IConditionGenerator;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class GreaterEqualGenerator
implements IConditionGenerator {
    @Override
    public Pair<OperandSize, String> generate(ITranslationEnvironment environment, long offset, List<ReilInstruction> instructions) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        Preconditions.checkArgument(offset >= 0L, "Error: Argument offset can't be less than 0");
        String xoredFlags = environment.getNextVariableString();
        String negatedResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(offset, OperandSize.BYTE, "OF", OperandSize.BYTE, "SF", OperandSize.BYTE, xoredFlags));
        instructions.add(ReilHelpers.createBisz(offset + 1L, OperandSize.BYTE, xoredFlags, OperandSize.BYTE, negatedResult));
        return new Pair<OperandSize, String>(OperandSize.BYTE, negatedResult);
    }
}

