/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class DivTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "div");
        if (instruction.getOperands().size() != 1) {
            throw new InternalTranslationException("Error: Argument instruction is not a div instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree divisorOperand = operands.get(0);
        OperandSize size = Helpers.getOperandSize(divisorOperand);
        TranslationResult resultDividend = Helpers.loadFirstDivOperand(environment, offset, size);
        instructions.addAll(resultDividend.getInstructions());
        offset = baseOffset + (long)instructions.size();
        String dividend = resultDividend.getRegister();
        TranslationResult resultDivisor = Helpers.translateOperand(environment, offset, divisorOperand, true);
        instructions.addAll(resultDivisor.getInstructions());
        offset = baseOffset + (long)instructions.size();
        String divisor = resultDivisor.getRegister();
        String divResult = environment.getNextVariableString();
        String modResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createDiv(offset++, size, dividend, size, divisor, size, divResult));
        instructions.add(ReilHelpers.createMod(offset++, size, dividend, size, divisor, size, modResult));
        instructions.addAll(Helpers.writeDivResult(environment, offset++, divResult, modResult, size));
        instructions.add(ReilHelpers.createUndef(offset++, OperandSize.BYTE, "AF"));
        instructions.add(ReilHelpers.createUndef(offset++, OperandSize.BYTE, "CF"));
        instructions.add(ReilHelpers.createUndef(offset++, OperandSize.BYTE, "OF"));
        instructions.add(ReilHelpers.createUndef(offset++, OperandSize.BYTE, "PF"));
        instructions.add(ReilHelpers.createUndef(offset++, OperandSize.BYTE, "SF"));
        instructions.add(ReilHelpers.createUndef(offset++, OperandSize.BYTE, "ZF"));
    }
}

