/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class CwdeTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "cwde");
        long baseOffset = instruction.getAddress().toLong() * 256L;
        String isolatedMsb = environment.getNextVariableString();
        String shiftedMsb = environment.getNextVariableString();
        String mask = environment.getNextVariableString();
        String truncatedMask = environment.getNextVariableString();
        String ax2 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset, OperandSize.DWORD, "eax", OperandSize.DWORD, "32768", OperandSize.DWORD, isolatedMsb));
        instructions.add(ReilHelpers.createBsh(baseOffset + 1L, OperandSize.DWORD, isolatedMsb, OperandSize.DWORD, "-15", OperandSize.DWORD, shiftedMsb));
        instructions.add(ReilHelpers.createSub(baseOffset + 2L, OperandSize.DWORD, "0", OperandSize.DWORD, shiftedMsb, OperandSize.DWORD, mask));
        instructions.add(ReilHelpers.createAnd(baseOffset + 3L, OperandSize.DWORD, mask, OperandSize.DWORD, "4294901760", OperandSize.DWORD, truncatedMask));
        instructions.add(ReilHelpers.createAnd(baseOffset + 4L, OperandSize.DWORD, "eax", OperandSize.DWORD, "65535", OperandSize.DWORD, ax2));
        instructions.add(ReilHelpers.createOr(baseOffset + 5L, OperandSize.DWORD, truncatedMask, OperandSize.DWORD, ax2, OperandSize.DWORD, "eax"));
    }
}

